% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inset_config.R
\name{config_insetmap}
\alias{config_insetmap}
\title{Configure inset map settings}
\usage{
config_insetmap(
  data_list,
  specs,
  crs = sf::st_crs("EPSG:4326"),
  border_args = list()
)
}
\arguments{
\item{data_list}{A list of spatial data objects (sf class). These data are used to compute the overall
bounding box and coordinate systems for the insets.}

\item{specs}{A non-empty list of \code{\link[=inset_spec]{inset_spec()}} objects.}

\item{crs}{Coordinate reference system to transform to, passed to
\code{\link[ggplot2:ggsf]{ggplot2::coord_sf()}} as \code{crs}. Default \code{"EPSG:4326"}.}

\item{border_args}{A list of named arguments passed to \code{\link[=map_border]{map_border()}} to style the
borders around inset plots. See \code{\link[=map_border]{map_border()}} for details
(defaults: \code{color = "black"}, \code{linewidth = 1}).}
}
\value{
An object of class \code{insetcfg}. Also stored as the last configuration, retrievable via \code{\link[=last_insetcfg]{last_insetcfg()}}.
}
\description{
Create and store an inset configuration used by \code{\link[=with_inset]{with_inset()}}. The
configuration contains subplot specifications, aspect ratio of the main plot,
CRS settings, and border appearance for insets.
}
\examples{
library(sf)

nc <- sf::st_read(system.file("shape/nc.shp", package = "sf"), quiet = TRUE)

config_insetmap(
    data_list = list(nc),
    specs = list(
        inset_spec(main = TRUE),
        inset_spec(
            xmin = -84, xmax = -75, ymin = 33, ymax = 37,
            loc = "left bottom", scale_factor = 0.5
        )
    )
)

}
\seealso{
\code{\link[=inset_spec]{inset_spec()}}, \code{\link[=with_inset]{with_inset()}}, \code{\link[=last_insetcfg]{last_insetcfg()}}
}
