% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secUrlDownload.R
\name{secUrlDownload}
\alias{secUrlDownload}
\title{secUrlDownload}
\usage{
secUrlDownload(quarter, year, form, name, email)
}
\arguments{
\item{quarter}{Specify the financial reporting quarter. Options are 1, 2, 3,
and 4.}

\item{year}{Specify the calendar year. Options range from 2004 to present.}

\item{form}{Specify the form type. Options are 4 or 5.}

\item{name}{Specify your name. This is required by the SEC.}

\item{email}{Specify your email. This is required by the SEC.}
}
\value{
A dataframe consisting of the URLs to the Form 4 or 5 text filings
for the specified quarter and year.
}
\description{
The function takes the specifieid quarter (1-4), year (2004-
2021), and form type (4 or 5) and returns a dataframe of URLs to each form
filed during the specified quarter.
}
\examples{
\donttest{
tempIndex <- secUrlDownload(quarter = 1, year = 2018, form = 4,
form = 4, name = "Your Name", email = "yourEmail@yourEmail.com")
}
}
