\name{os.shutdown}
\alias{os.shutdown}
\title{Shut down the operating system with the command `shutdown'}
\usage{
  os.shutdown(s = 0, m = 0, h = 0)
}
\arguments{
  \item{s}{time to wait before shutting down (in seconds),
  added to m and h; passed to
  \code{\link[base]{Sys.sleep}}}

  \item{m}{time to wait before shutting down (in minutes),
  added to s and h; passed to
  \code{\link[base]{Sys.sleep}}}

  \item{h}{time to wait before shutting down (in hours),
  added to s and m; passed to
  \code{\link[base]{Sys.sleep}}}
}
\value{
  The status code of \code{\link[base]{system}}.
}
\description{
  There is a command \command{shutdown} in both Windows and
  Linux, and this function uses it to shut down a computer.

  After the time \code{wait} has passed, R will execute
  \command{shutdown -s -t 0} (for Windows) or
  \command{shutdown -h now} to shut down the computer.

  This function is a modified version of Yihui's shutdown
  function from the {fun} package.
}
\examples{
\dontrun{
## when your code is extremely time-consuming,
# you may need this function;
# e.g. you wish to go to sleep, while keeping R running long computation...

os.shutdown()
## the next day you wake up, "thank you, R" :)
}
}
\author{
  Yihui Xie <\url{http://yihui.name}>, and Tal Galili
}
\references{
  \url{http://cos.name/en/topic/shut-down-your-windows-with-r}
  ,
  \url{https://github.com/yihui/fun/blob/master/R/shutdown.R}
}
\seealso{
  \code{\link[base]{system}},\code{\link[base]{shell}},
  \code{\link[base]{Sys.sleep}}, \code{\link{is.windows}},
  \code{\link{os.shutdown}}, \code{\link{os.sleep}},
  \code{\link{os.hibernate}}, \code{\link{os.lock}},
  \code{\link{os.restart}}
}

