% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_rmse.R
\name{bootstrap_rmse}
\alias{bootstrap_rmse}
\title{Bootstrapped RMSE}
\usage{
bootstrap_rmse(
  model,
  data,
  n = 50,
  frac = 1,
  show_progress = TRUE,
  rmse_model = NULL
)
}
\arguments{
\item{model}{a model object}

\item{data}{data used to fit model object}

\item{n}{number of bootstrap replicates (defaults to 50)}

\item{frac}{fraction used in training set if cross-validation is applied (defaults to 1)}

\item{show_progress}{show progress bar (defaults to TRUE)}

\item{rmse_model}{numeric RMSE to show as vertical dashed line in autoplot() (defaults to NULL)}
}
\value{
A list with components
\item{rmse_bs}{numerical vector with \code{n} root mean squared errors}
\item{rmse_mod}{root mean squared error for fitted (i.e. original) model}
}
\description{
Generate \code{n} bootstrap replicates to compute \code{n} root mean squared errors.
}
\details{
To test the predictive ability of the fitted model it might be helpful to determine the variation in the computed RMSE.
The variation is calculated by computing the root mean squared errors from \code{n} generated bootstrap replicates. More precisely,
for each iteration a sample with replacement is taken from the data set and the model is refitted using this sample. Then, the root
mean squared error is calculated.
}
\examples{
\dontrun{
mod1 <- glm(nclaims ~ age_policyholder, data = MTPL,
    offset = log(exposure), family = poisson())

# Use all records in MTPL
x <- bootstrap_rmse(mod1, MTPL, n = 80, show_progress = FALSE)
print(x)
autoplot(x)

# Use 80\% of records to test whether predictive ability depends on which 80\% is used
# This might for example be useful in case portfolio contains large claim sizes
x_frac <- bootstrap_rmse(mod1, MTPL, n = 50, frac = .8, show_progress = FALSE)
autoplot(x_frac) # Variation is quite small for Poisson GLM
}

}
\author{
Martin Haringa
}
