% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gride_evolution.R
\name{gride_evolution}
\alias{gride_evolution}
\alias{print.gride_evolution}
\alias{plot.gride_evolution}
\title{\code{Gride} evolution based on Maximum Likelihood Estimation}
\usage{
gride_evolution(X, vec_n1, vec_n2, upp_bound = 50)

\method{print}{gride_evolution}(x, ...)

\method{plot}{gride_evolution}(x, ...)
}
\arguments{
\item{X}{data matrix with \code{n} observations and \code{D} variables.}

\item{vec_n1}{vector of integers, containing the smaller NN orders considered
in the evolution.}

\item{vec_n2}{vector of integers, containing the larger NN orders considered
in the evolution.}

\item{upp_bound}{upper bound for the interval used in the numerical
optimization (via \code{optimize}). Default set to 50.}

\item{x}{an object of class \code{gride_evolution}.}

\item{...}{other arguments passed to specific methods.}
}
\value{
list containing the Gride evolution, the corresponding NN distance
ratios, the average n2-th NN order distances, and the NN orders considered.

the function prints a summary of the Gride evolution to
console.
}
\description{
The function allows the study of the evolution of the \code{id} estimates
as a function of the scale of a dataset. A scale-dependent analysis
is essential to identify the correct number of relevant directions in noisy
data. To increase the average distance from the second NN (and thus the
average neighborhood size) involved in the estimation, the function computes
a sequence of \code{Gride} models with increasing NN orders, \code{n1} and
\code{n2}.
See also \href{https://arxiv.org/abs/2104.13832}{Denti et al., 2021+}
for more details.
}
\examples{
\donttest{
X       <-  replicate(5,rnorm(10000,0,.1))
gride_evolution(X = X,vec_n1 = 2^(0:5),vec_n2 = 2^(1:6))
}

}
\references{
Denti F, Doimo D, Laio A, Mira A (2022+). "Distributional Results for
Model-Based Intrinsic Dimension Estimators."
arXiv preprint. 2104.13832, \url{https://arxiv.org/abs/2104.13832}.
}
