% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doPareto.R
\name{doPareto}
\alias{doPareto}
\title{Prioritization of genes based on Z scores}
\usage{
doPareto(df_final, objective, nr.fronts)
}
\arguments{
\item{df_final}{a data frame which is the output of doIntegration.}

\item{objective}{a data frame which include column of "mark" column indicates the z scores of
markers of histone modifications (e.g. "z.H3K4me3"), and a column named "obj"
indicates the direction of the operation on the z scores, one of "max" and
"min".}

\item{nr.fronts}{the number of the pareto fronts you want to get.}
}
\value{
a data.frame ranked by the level of pareto fronts.
}
\description{
\code{doPareto} takes the Z scores of several different histone modifications
as input, the prioritization of genes based on Z scores can be formulated as
multiobjective optimization problem and solved with Pareto optimization.
}
\examples{
data("df_final")
objective <- data.frame(mark = c("z.H3K27ac","z.H3K4me3"),
                        obj=c("max","max"),stringsAsFactors=FALSE)
nr.fronts <- 3
doPareto(df_final = df_final,
         objective = objective,
         nr.fronts = nr.fronts)
}
