% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrspline.R
\name{loglinHR}
\alias{loglinHR}
\title{Linear interaction HR}
\usage{
loglinHR(
  var2values,
  model,
  data,
  var1,
  var2,
  ci = TRUE,
  conf = 0.95,
  ci.method = "delta",
  ci.boot.method = "perc",
  R = 100,
  parallel = "multicore",
  ...
)
}
\arguments{
\item{var2values}{numeric vector of var2 points to estimate}

\item{model}{model of class coxph or cph. If data is NULL, the function expects to find the data in model$x}

\item{data}{data used in the model. If absent, it will attempt to recover the data from the model object. Only used for bootstrap CI}

\item{var1}{variable that increases by 1 unit from 0}

\item{var2}{variable to spline. var2values belong to var2}

\item{ci}{calculate 95\% CI?}

\item{conf}{confidence level. Default 0.95}

\item{ci.method}{confidence interval method. "delta" performs delta method. "bootstrap" performs bootstrapped CI (slower)}

\item{ci.boot.method}{one of the available bootstrap CI methods from \code{\link[boot]{boot.ci}}. Default percentile}

\item{R}{number of bootstrap samples if ci.method = "bootstrap". Default 100}

\item{parallel}{can take values "no", "multicore", "snow" if ci.method = "bootstrap". Default multicore}

\item{...}{other parameters for boot}
}
\value{
if ci = FALSE, a vector of estimate of length(var2values),
if ci = TRUE a dataframe with 5 columns, initial values, HR, lower CI, upper CI and SE
}
\description{
Generate HR values for a 1 unit increase in a variable at
specified points of another interacting variable in a simple Cox interaction model
}
\examples{
library(survival)
data(cancer)
myformula <- Surv(time, status) ~ ph.karno + ph.ecog + age*sex
model <- coxph(myformula , data = lung )
loglinHR( var2values = 40:80
                     , model = model , data = lung , var1 ="sex", var2="age"
                     , ci=TRUE , conf = 0.95 , ci.method = "delta")
}
