% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/findMultiLims.R
\name{findMultiLims}
\alias{findMultiLims}
\title{Determine Critical t-Statistic For Marginal Effects Plot}
\usage{
findMultiLims(mat1, mat2 = NULL, mat3 = NULL, mat4 = NULL, p1 = 99,
  p2 = NULL, p3 = NULL, p4 = NULL, type = "any", err = 0.05)
}
\arguments{
\item{mat1}{Matrix of bootstrapped samples of marginal effects.}

\item{mat2}{Matrix of bootstrapped samples of marginal effects.}

\item{mat3}{Matrix of bootstrapped samples of marginal effects.}

\item{mat4}{Matrix of bootstrapped samples of marginal effects.}

\item{p1}{The type of hypothesis test for the marginal effects in mat1. 1 = one-sided test for ME > 0, -1 = one-sided test for ME < 0, 0 = null of ME = 0 cannot be rejected, any other value = two-sided test for ME != 0}

\item{p2}{The type of hypothesis test for the marginal effects in mat2. 1 = one-sided test for ME > 0, -1 = one-sided test for ME < 0, 0 = null of ME = 0 cannot be rejected, any other value = two-sided test for ME != 0}

\item{p3}{The type of hypothesis test for the marginal effects in mat3. 1 = one-sided test for ME > 0, -1 = one-sided test for ME < 0, 0 = null of ME = 0 cannot be rejected, any other value = two-sided test for ME != 0}

\item{p4}{The type of hypothesis test for the marginal effects in mat4. 1 = one-sided test for ME > 0, -1 = one-sided test for ME < 0, 0 = null of ME = 0 cannot be rejected, any other value = two-sided test for ME != 0}

\item{type}{The condition that corresponds to successful rejection of the null. "any" indicates any of the matK marginal effects are statistically significant in the direction given by pK, "all" = ALL of the matK marginal effects are statistically significant and in the direction given by pK}

\item{err}{Rejection rate.}
}
\value{
The limits of the t-statistic for the given rejection rate
}
\description{
This function determines the appropriate critical t-statistic
that limits the false null rejection rate of a marginal effects plot
to a specified value, err, using bootstrapped samples of calculated
marginal effects values.
}
\examples{
\dontrun{
  data(legfig)                # Clark and Golder 2006 replication data
  set.seed(1231124)

  # limit to established democracies from the 1990s
  dat<-subset(legfig, subset=(nineties==1 & old==1))

  # create bootstrap samples of marginal effects of eneg and logmag on enep1
  # uses the bootFun utility included in this package
  library(boot)
  boot.t.dist <- boot(data = dat, statistic = bootFun, R = 1000,
            form=enep1 ~ eneg * logmag + uppertier_eneg + uppertier + proximity1 +
            proximity1_enpres + enpres, fam="gaussian", x.name="eneg",
            z.name="logmag")$t
  boot.t.x.dist<-boot.t.dist[,1:10]


  # calculate critical t-statistic that sets familywise error rate to 10\%
  # for statistical significance of marginal effect of of eneg at any value of logmag
  findMultiLims(boot.t.x.dist, type="any", err=0.1)$minimum # answer: 2.593086

  # calculate critical t-statistic that sets FWER to 10\% for ME of eneg = 0
  # when logmag is small and ME of eneg > 0 when logmag is large
  boot.t.x.dist.lo<-boot.t.dist[,1:5]
  boot.t.x.dist.hi<-boot.t.dist[,6:10]
  findMultiLims(boot.t.x.dist.lo, boot.t.x.dist.hi, type="all", p1=0,
                  p2=1, err=0.1)$minimum     # answer: 1.008688
}
}
\author{
Justin Esarey and Jane Lawrence Sumner
}
\references{
Clark, William R., and Matt Golder. 2006. "Rehabilitating Duverger's Theory." \emph{Comparative Political Studies} 39(6): 679-708.

Esarey, Justin, and Jane Lawrence Sumner. 2015. "Marginal Effects in Interaction Models: Determining and Controlling the False Positive Rate." URL: http://jee3.web.rice.edu/interaction-overconfidence.pdf.
}

