% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_margins.R
\name{sim_margins}
\alias{sim_margins}
\title{Perform a simple margins analysis.}
\usage{
sim_margins(model, pred, modx, mod2 = NULL, modx.values = NULL,
  mod2.values = NULL, data = NULL, cond.int = FALSE,
  vce = c("delta", "simulation", "bootstrap", "none"),
  iterations = 1000, digits = getOption("jtools-digits", default = 2),
  pvals = TRUE, confint = FALSE, ci.width = 0.95, cluster = NULL,
  modx.labels = NULL, mod2.labels = NULL, ...)
}
\arguments{
\item{model}{A regression model. The function is tested with \code{lm},
\code{glm}, \code{\link[survey]{svyglm}}, \code{\link[lme4]{merMod}},
\code{\link[quantreg]{rq}}, \code{\link[brms]{brmsfit}},
\code{stanreg} models.
Models from other classes may work as well but are not officially
supported. The model should include the interaction of interest.}

\item{pred}{The name of the predictor variable involved
in the interaction. This can be a bare name or string. Note that it
is evaluated using \code{rlang}, so programmers can use the \code{!!} syntax
to pass variables instead of the verbatim names.}

\item{modx}{The name of the moderator variable involved
in the interaction. This can be a bare name or string. The same
\code{rlang} proviso applies as with \code{pred}.}

\item{mod2}{Optional. The name of the second moderator
variable involved in the interaction. This can be a bare name or string.
The same \code{rlang} proviso applies as with \code{pred}.}

\item{modx.values}{For which values of the moderator should lines be
plotted? There are two basic options:
\itemize{
\item A vector of values (e.g., \code{c(1, 2, 3)})
\item A single argument asking to calculate a set of values. See details
below.
}

Default is \code{NULL}. If \code{NULL} (or \code{mean-plus-minus}),
then the customary +/- 1 standard
deviation from the mean as well as the mean itself are used for continuous
moderators. If \code{"plus-minus"}, plots lines when the moderator is at
+/- 1 standard deviation without the mean. You may also choose \code{"terciles"}
to split the data into equally-sized groups and choose the point at the
mean of each of those groups.

If the moderator is a factor variable and \code{modx.values} is
\code{NULL}, each level of the factor is included. You may specify
any subset of the factor levels (e.g., \code{c("Level 1", "Level 3")}) as long
as there is more than 1. The levels will be plotted in the order you
provide them, so this can be used to reorder levels as well.}

\item{mod2.values}{For which values of the second moderator should the plot
be
facetted by? That is, there will be a separate plot for each level of this
moderator. Defaults are the same as \code{modx.values}.}

\item{data}{Optional, default is NULL. You may provide the data used to
fit the model. This can be a better way to get mean values for centering
and can be crucial for models with variable transformations in the formula
(e.g., \code{log(x)}) or polynomial terms (e.g., \code{poly(x, 2)}). You will
see a warning if the function detects problems that would likely be
solved by providing the data with this argument and the function will
attempt to retrieve the original data from the global environment.}

\item{cond.int}{Should conditional intercepts be printed in addition to the
slopes? Default is \code{FALSE}.}

\item{vce}{A character string indicating the type of estimation procedure to use for estimating variances. The default (\dQuote{delta}) uses the delta method. Alternatives are \dQuote{bootstrap}, which uses bootstrap estimation, or \dQuote{simulation}, which averages across simulations drawn from the joint sampling distribution of model coefficients. The latter two are extremely time intensive.}

\item{iterations}{If \code{vce = "bootstrap"}, the number of bootstrap iterations. If \code{vce = "simulation"}, the number of simulated effects to draw. Ignored otherwise.}

\item{digits}{An integer specifying the number of digits past the decimal to
report in the output. Default is 2. You can change the default number of
digits for all jtools functions with
\code{options("jtools-digits" = digits)} where digits is the desired
number.}

\item{pvals}{Show p values? If \code{FALSE}, these
are not printed. Default is \code{TRUE}.}

\item{confint}{Show confidence intervals instead of standard errors? Default
is \code{FALSE}.}

\item{ci.width}{A number between 0 and 1 that signifies the width of the
desired confidence interval. Default is \code{.95}, which corresponds
to a 95\% confidence interval. Ignored if \code{confint = FALSE}.}

\item{cluster}{For clustered standard errors, provide the column name of
the cluster variable in the input data frame (as a string). Alternately,
provide a vector of clusters.}

\item{modx.labels}{A character vector of labels for each level of the
moderator values, provided in the same order as the \code{modx.values}
argument. If \code{NULL}, the values themselves are used as labels unless
\code{modx,values} is also \code{NULL}. In that case, "+1 SD" and "-1 SD"
are used.}

\item{mod2.labels}{A character vector of labels for each level of the 2nd
moderator values, provided in the same order as the \code{mod2.values}
argument. If \code{NULL}, the values themselves are used as labels unless
\code{mod2.values} is also \code{NULL}. In that case, "+1 SD" and "-1 SD"
are used.}

\item{...}{ignored.}
}
\value{
A list object with the following components:

\item{slopes}{A table of coefficients for the focal predictor at each
value of the moderator}
\item{ints}{A table of coefficients for the intercept at each value of the
moderator}
\item{modx.values}{The values of the moderator used in the analysis}
}
\description{
\code{sim_margins} conducts a simple margins analysis for the purposes of
understanding two- and three-way interaction effects in linear regression.
}
\details{
This allows the user to perform a simple margins analysis for the
purpose of probing interaction effects in a linear regression. Two- and
three-way interactions are supported, though one should be warned that
three-way interactions are not easy to interpret in this way.

The function is tested with \code{lm}, \code{glm}, \code{svyglm}, and \code{merMod} inputs.
Others may work as well, but are not tested. In all but the linear model
case, be aware that not all the assumptions applied to simple slopes
analysis apply.
}
\references{
Bauer, D. J., & Curran, P. J. (2005). Probing interactions in fixed and
multilevel regression: Inferential and graphical techniques.
\emph{Multivariate Behavioral Research}, \emph{40}(3), 373-400.
\url{https://doi.org/10.1207/s15327906mbr4003_5}

Cohen, J., Cohen, P., West, S. G., & Aiken, L. S. (2003). \emph{Applied
multiple regression/correlation analyses for the behavioral sciences} (3rd
ed.). Mahwah, NJ: Lawrence Erlbaum Associates, Inc.

Hanmer, M. J., & Kalkan, K. O. (2013). Behind the curve: Clarifying the best
approach to calculating predicted probabilities and marginal effects from
limited dependent variable models. \emph{American Journal of Political Science},
\emph{57}, 263–277. \url{https://doi.org/10.1111/j.1540-5907.2012.00602.x}
}
\seealso{
\code{\link[margins:margins]{margins::margins()}}

Other interaction tools: \code{\link{johnson_neyman}},
  \code{\link{probe_interaction}}, \code{\link{sim_slopes}}
}
\author{
Jacob Long <\email{long.1377@osu.edu}>
}
\concept{interaction tools}
