% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ia_get_item.R
\name{ia_get_items}
\alias{ia_get_items}
\title{Get the metadata for Internet Archive items}
\usage{
ia_get_items(item_id, silence = FALSE)
}
\arguments{
\item{item_id}{A character vector containing the ID for an Internet Archive
item. This argument is vectorized, so you can retrieve multiple items at
once.}

\item{silence}{If false, print the item IDs as they are retrieved.}
}
\value{
A list containing the metadata returned by the API. List names
  correspond to the item IDs.
}
\description{
Get the metadata for Internet Archive items
}
\examples{
\dontrun{
ia_get_items("thedamnationofth00133gut")

ats_query <- c("publisher" = "american tract society")
ids       <- ia_search(ats_query, num_results = 2)
ia_get_items(ids)
}
}

