% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ia_metadata.R
\name{ia_metadata}
\alias{ia_metadata}
\title{Access the item metadata from an Internet Archive item}
\usage{
ia_metadata(items)
}
\arguments{
\item{items}{A list object describing an Internet Archive items returned from
the API.}
}
\value{
A data frame containing the metadata, with columns \code{id} for the
  item identifier, \code{field} for the name of the metadata field, and
  \code{value} for the metadata values.
}
\description{
Access the item metadata from an Internet Archive item
}
\examples{
ats_query <- c("publisher" = "american tract society")
ids       <- ia_search(ats_query, num_results = 3)
items     <- ia_get_items(ids)
metadata  <- ia_metadata(items)
metadata
}

