% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simData4iCoxph.R
\name{simData4iCoxph}
\alias{simData4iCoxph}
\title{Simulated Survival Data with Uncertain Records}
\usage{
simData4iCoxph(nSubject = 1e3, beta0Vec, xMat,
               maxNum = 2, nRecordProb = c(0.9, 0.1),
               matchCensor = 0.1, matchEvent = 0.1,
               censorMin = 0.5, censorMax = 12.5,
               lambda = 0.005, rho = 0.7,
               fakeLambda1 = lambda * exp(- 3), fakeRho1 = rho,
               fakeLambda2 = lambda * exp(3), fakeRho2 = rho,
               mixture = 0.5, randomMiss = TRUE,
               eventOnly = FALSE, ...)
}
\arguments{
\item{nSubject}{Number of subjects.}

\item{beta0Vec}{Time-invariant covariate coefficients.}

\item{xMat}{Design matrix. By default, three continuous variables following
standard normal distribution and one binary variable following Bernoulli
distribution with equal probability are used.}

\item{maxNum}{Maximum number of uncertain records.}

\item{nRecordProb}{Probability of the number of uncertain records.}

\item{matchCensor}{The matching rate for subjects actually having censoring
times.}

\item{matchEvent}{The matching rate for subjects actually having event
times.}

\item{censorMin}{The lower boundary of the uniform distribution for
generating censoring time.}

\item{censorMax}{The upper boundary of the uniform distribution for
generating censoring time.}

\item{lambda}{A positive number, scale parameter in baseline rate function
for true event times.}

\item{rho}{A positive number, shape parameter in baseline rate function for
true event times.}

\item{fakeLambda1}{A positive number, scale parameter in baseline rate
function for fake event times from one distribution.}

\item{fakeRho1}{A positive number, shape parameter in baseline rate function
for fake event times from one distribution.}

\item{fakeLambda2}{A positive number, scale parameter in baseline rate
function for fake event times from another distribution.}

\item{fakeRho2}{A positive number, shape parameter in baseline rate function
for fake event times from another distribution.}

\item{mixture}{The mixture weights, i.e., the probabilities (summing up to
one) of fake event times coming from different mixture components.}

\item{randomMiss}{A logical value specifying whether the labels of the true
records are missing completely at random (MCAR) or missing not at random
(MNAR). The default value is \code{TRUE} for MCAR.}

\item{eventOnly}{A logical value specifying whether the uncertain records
only include possible events. The default value is \code{FALSE}, which
considers the censoring cases as the possible truth in addition to event
records.}

\item{...}{Other arguments for future usage.}
}
\value{
A data frame with the following columns,

\itemize{

\item \code{ID}: subject ID

\item \code{time}: observed event times

\item \code{event}: event indicators

\item \code{isTure}: latent labels indicating the true records

}

and the corresponding covariates.
}
\description{
Generate survival data with uncertain records.  An integrative Cox model can
be fitted for the simulated data by function \code{\link{iCoxph}}.
}
\details{
The event times are simulated from a Weibull proportional hazard model of
given shape and baseline scale.  The censoring times follow uniform
distribution of specified boundaries.
}
\examples{
## See examples of function iCoxph
}
