% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sim_base_pois.R
\name{sim_base_pois}
\alias{sim_base_pois}
\title{sim_base_pois}
\usage{
sim_base_pois(
  demand,
  lambda,
  leadtime,
  service_level,
  Base = FALSE,
  shortage_cost = FALSE,
  inventory_cost = FALSE,
  ordering_delay = FALSE,
  ordering_cost = FALSE
)
}
\arguments{
\item{demand}{A vector of demand in N time periods.}

\item{lambda}{rate of demand in N time periods.}

\item{leadtime}{lead time from order to arrival}

\item{service_level}{cycle service level requested}

\item{Base}{Set to False for automatic calculation,else manual input of base.}

\item{shortage_cost}{shortage cost per unit of sales lost.}

\item{inventory_cost}{inventory cost per unit.}

\item{ordering_delay}{logical,Default is FALSE,if TRUE, orders are delayed one period.}

\item{ordering_cost}{ordering cost for every time an order is made.}
}
\value{
a list of two date frames, the simulation and the metrics.
}
\description{
Simulating a Min,max policy or aslo called s,S policy,  .
}
\details{
The Function takes a demand vector, mean of demand ,sd,lead time and requested service level to simulate and inventory system, 
orders are lost if inventory level is less than requested demand, also ordering is made at
 day t+1, metrics like item fill rate and cycle service level are calculated 
 based on poisson distribution..
}
\examples{
sim_base_pois(demand = rpois(50,8),lambda = 4,leadtime = 4,shortage_cost = 20,ordering_delay=FALSE,
Base  = FALSE,service_level = 0.70,inventory_cost = 50,ordering_cost=50)
}
\author{
"haytham omar  email: <haytham@rescaleanalytics.com>"
}
