% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hessian_funs.R
\name{calc_hessian}
\alias{calc_hessian}
\title{Calculate Hessian}
\usage{
calc_hessian(
  pars_opt,
  pars_const,
  observations,
  modelfun,
  dose_norm,
  log10_trans
)
}
\arguments{
\item{pars_opt}{Named numeric: A vector of parameter values for the parameters
that were optimized. For example, you can get this using
[coef.pk()] with `include_type = "optim"`.}

\item{pars_const}{Named numeric: A vector of parameter values for parameters
that were held constant, not optimized (but are necessary to evaluate the
model). For example, you can get this using [coef.pk()] with `include_type =
"const"`.}

\item{observations}{The data used to fit the model. For example, you can get
this using [get_data.pk()].}

\item{modelfun}{The name of the function that evaluates the model (passed to
[log_likelihood()]).}

\item{dose_norm}{Logical: Whether to dose-normalize concentrations before
evaluating log-likelihood. Passed to [log_likelihood()].}

\item{log10_trans}{Logical: Whether to log10-transform concentrations before
evaluating log-likelihood. Passed to [log_likelihood()].}
}
\value{
A square numeric matrix, both dimensions the same as the length of
 `pars_opt`. It will have rownames and column names that are the same as the
 names of `pars_opt`.
}
\description{
Calculate Hessian matrix given parameter values and data
}
\details{
Calculate the Hessian matrix: the matrix of second derivatives of the
objective function with respect to parameters, evaluated for a single set of
parameter values for a single model and a single data set.
Here, the objective function is the negative
log-likelihood implemented in [log_likelihood()], evaluated jointly across the
data that was used to fit the model.
This is a workhorse function called by [get_hessian.pk()] and, indirectly, by
[coef_sd.pk()]. When the number of optimized parameters is \eqn{n}, the
respective Hessian matrix will be \eqn{n \times n}.
}
\author{
Caroline Ring
}
