% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_params_1comp_fup.R
\name{get_params_1comp_fup}
\alias{get_params_1comp_fup}
\title{Get parameters for 1-compartment model with clearance assumption}
\usage{
get_params_1comp_fup(
  data,
  lower_bound = ggplot2::aes(Q_totli = NA, Q_gfr = NA, Fup = 0, Clint = 0, Vdist = 0.01,
    Fgutabs = 0, kgutabs = log(2)/(2 * max(Time_trans)), Fgutabs_Vdist = 0.01,
    Rblood2plasma = 0.01),
  upper_bound = ggplot2::aes(Q_totli = NA, Q_gfr = NA, Fup = 1, Clint = 1e+05, Vdist =
    100, Fgutabs = 1, kgutabs = log(2)/(0.5 * min(Time_trans[Time_trans > 0])),
    Fgutabs_Vdist = 100, Rblood2plasma = 100),
  param_units = ggplot2::aes(Q_totli = "L/h/kg ^3/4", Q_gfr = "L/h/kg ^3/4", Fup =
    "unitless fraction", Clint = "L/h/kg", Vdist = paste0("(", unique(Dose.Units), ")",
    "/", "(", unique(Conc.Units), ")"), Fgutabs = "unitless fraction", kgutabs =
    paste0("1/", unique(Time_trans.Units)), Fgutabs_Vdist = paste0("(",
    unique(Conc.Units), ")", "/", "(", unique(Dose.Units), ")"), Rblood2plasma =
    "unitless ratio")
)
}
\arguments{
\item{data}{The data set to be fitted (e.g. the result of [preprocess_data()])}

\item{lower_bound}{A mapping specified using a call to [ggplot2::aes()],
giving the lower bounds for each variable, as expressions which may include
variables in `data`.}

\item{upper_bound}{A mapping specified using a call to [ggplot2::aes()],
giving the upper bounds for each variable, as expressions which may include
variables in `data`.}

\item{param_units}{A mapping specified using a call to [ggplot2::aes()],
giving the units for each variable, as expressions which may include
variables in `data`.}
}
\value{
A `data.frame`with the following variables:
- `param_name`: Character: Names of the model parameters
- `param_units`: Character: Units of the model parameters
- `optimize_param`: TRUE if each parameter is to be estimated from the data; FALSE otherwise
- `use_param`: TRUE if each parameter is to be used in evaluating the model; FALSE otherwise
-`lower_bounds`: Numeric: The lower bounds for each parameter
- `upper_bounds`: Numeric: The upper bounds for each parameter
- `start`: Numeric: The starting guesses for each parameter
}
\description{
Get parameters for 1-compartment model and determine whether each is to be
estimated from the data
}
\details{
The full set of model parameters for the 1-compartment model includes `Vdist`,
`Clint`, `kgutabs`, `Fgutabs`, `Q_totli`, `Q_gfr`, `Fup`, and `Rblood2plasma`.
Whether each one can be estimated from the data depends on which routes of administration
are included in the data.

# Constant parameters from `httk`
`Q_totli` is the flow through the portal vein from the gut to the liver
and is estimated in this model via [httk::tissue.data] in a species-specific manner.
`Q_gfr` is the glomular filtration rate of kidneys. It is estimated via
[httk::physiology.data] in a species specific manner.
`Fup` and `Rblood2plasma` are both calculated in [httk::parameterize_1comp()]
For each of these parameters default lower bounds are 10% and 110% of the starting value

# IV data, no oral data

If IV dosing data are available, but no oral dosing data are available, then
only the parameters `Vdist` and `kelim` will be estimated from the data. The
parameters `kgutabs` and `Fgutabs` cannot be estimated from IV data alone, and
will not be used in evaluating the model.

# Oral data, no IV data

If oral dosing data are available, but no IV dosing data are available, then
the parameters `kelim` and `kgutabs` can be estimated from the data. However,
the parameters `Fgutabs` and `Vdist` cannot be identified separately. From
oral data alone, only the ratio `Fgutabs/Vdist` can be identified. This ratio
is represented by a single parameter named `Fgutabs_Vdist`. `Fgutabs` and
`Vdist` will not be used to evaluate the model nor be estimated from data, but
`Fgutabs_Vdist` will be estimated from data, along with `kelim` and `kgutabs`.

# Oral data and IV data

If both oral and IV dosing data are available, then `Vdist`, `kelim`,
`kgutabs`, and `Fgutabs` will all be estimated from the data.

# Blood and plasma data

If both blood and plasma data are available, then `Rblood2plasma` will be
estimated from the data.

# Only one of blood or plasma data

If only one of blood or plasma data are available, then `Rblood2plasma` will be
held constant at 1, not estimated from the data.

# Default lower and upper bounds for each parameter

## Default lower and upper bounds for `kelim` and `kgutabs`

Default bounds for time constants `kelim` and `kgutabs` are set based on
the time scale of the available data.

The lower bounds are based on the assumption that elimination and absorption
are very slow compared to the time scale of the study. Specifically, the
lower bounds assume that elimination and absorption half-lives are twice as
long as the duration of the available study data, or `2*max(Time_trans)`.
Under this assumption, the corresponding elimination and absorption time
constants would be `log(2)/(2*max(Time_trans))`. Therefore, the default lower
bounds for `kelim` and `kgutabs` are `log(2)/(2*max(Time_trans))`.

Upper bounds are based on the opposite assumption: that elimination and
absorption are very fast compared to the time scale of the study.
Specifically, the upper bounds assume that the elimination and absorption
half-lives are half as long as the time of the first observation after time
0, or `0.5*min(Time_trans[Time_trans>0])`. Under this asumption, the
corresponding elimination and absorption time constants would be
`log(2)/(0.5*min(Time_trans[Time_trans>0]))`. Therefore, the default lower
bounds for `kelim` and `kgutabs` are
`log(2)/(0.5*min(Time_trans[Time_trans>0]))`.

## Default lower and upper bounds for `Vdist`

By default, the lower bound for `Vdist` is 0.01, and the upper bound for
`Vdist` is 100. These values were chosen based on professional judgment.

## Default lower and upper bounds for `Fgutabs`

By default, the lower bound for `Fgutabs` is 0.0, and the upper bound for
`Fgutabs` is 1. These are simply the bounds of the physically-meaningful
range for a fraction.

## Default lower and upper bounds for `Fgutabs_Vdist`

By default, the lower bound for the ratio `Fgutabs_Vdist` is 0.01, and the
upper bound is 100. These values were chosen based on professional judgment.

## Default lower and upper bounds for `Rblood2plasma`

By default, the lower bound for the blood:plasma partition coefficient
`Rblood2plasma` is 0.01, and the upper bound is 100. These values were chosen
based on professional judgment.

# Starting values for each parameter

Starting values for each parameter (starting guesses for the numerical
optimizer) are derived from the data using [get_starts_1comp()].

If the starting values returned by [get_starts_1comp()] fall outside the
bounds for any parameter(s), then the starting value will be reset to a value
halfway between the lower and upper bounds for that parameter.
}
\seealso{
Other 1-compartment model functions: 
\code{\link{auc_1comp}()},
\code{\link{auc_1comp_cl}()},
\code{\link{cp_1comp}()},
\code{\link{cp_1comp_cl}()},
\code{\link{get_params_1comp}()},
\code{\link{get_params_1comp_cl}()},
\code{\link{get_starts_1comp}()},
\code{\link{get_starts_1comp_cl}()},
\code{\link{get_starts_1comp_fup}()}

Other get_params functions: 
\code{\link{get_params_1comp}()},
\code{\link{get_params_1comp_cl}()},
\code{\link{get_params_2comp}()},
\code{\link{get_params_flat}()}

Other built-in model functions: 
\code{\link{auc_1comp}()},
\code{\link{auc_1comp_cl}()},
\code{\link{auc_2comp}()},
\code{\link{auc_flat}()},
\code{\link{cp_1comp}()},
\code{\link{cp_1comp_cl}()},
\code{\link{cp_2comp}()},
\code{\link{cp_2comp_dt}()},
\code{\link{cp_flat}()},
\code{\link{get_params_1comp}()},
\code{\link{get_params_1comp_cl}()},
\code{\link{get_params_2comp}()},
\code{\link{get_params_flat}()},
\code{\link{get_starts_1comp}()},
\code{\link{get_starts_1comp_cl}()},
\code{\link{get_starts_1comp_fup}()},
\code{\link{get_starts_2comp}()},
\code{\link{get_starts_flat}()},
\code{\link{tkstats_2comp}()},
\code{\link{transformed_params_2comp}()}
}
\author{
Caroline Ring, Gilberto Padilla Mercado
}
\concept{1-compartment model functions}
\concept{built-in model functions}
\concept{get_params functions}
