% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_methods_get_winning_model.R
\name{get_winning_model.pk}
\alias{get_winning_model.pk}
\title{Get winning model}
\usage{
\method{get_winning_model}{pk}(obj, newdata = NULL, method = NULL, criterion = "AIC", ...)
}
\arguments{
\item{obj}{A [pk()] object}

\item{newdata}{Optional: A `data.frame` containing new data to plot. Must
contain at least variables `Chemical`, `Species`, `Route`, `Media`, `Dose`,
`Time`, `Time.Units`, `Conc`, `Detect`, `Conc_SD`.  Default `NULL`, to use
the data in `obj$data`.}

\item{method}{Character: One or more of the [optimx::optimx()] methods used in
fitting. The winning model will be determined for each of these methods.
Default `NULL` to get the winning model for each method in
`obj$settings_optimx$method`.}

\item{criterion}{The name of a criterion function to use for model comparison.
Default "AIC". Must be the name of a function that (as for `AIC`) accepts
arguments `obj`, `newdata`, `method` and `model` (may accept other
arguments, specified in `...`) and returns output as for `AIC`: a data.frame
with a column with the same name as `criterion` that has calculated values
for model comparison. The "winning" value will be the smallest value.}

\item{...}{Optional: Other arguments to `criterion` function.}
}
\value{
A data.frame with one row for each `data_group`, `model` and `method` and
 The return value has attribute `criterion` giving the name of the criterion function used to compare
 models.
}
\description{
Get winning model for a fitted `pk` object
}
\details{
Get the winning model (i.e. the model with the lowest value of the criterion
specified in `criterion`) for a fitted `pk` object, for a specified method,
and optionally for a specified new dataset. When there are ties it will
return the first encounter, where the priority is: model_1comp > model_2comp > model_flat.
}
\author{
Caroline Ring, Gilberto Padilla Mercado
}
