% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ind_excl.R
\encoding{utf-8}
\name{ind_excl}
\alias{ind_excl}
\title{Wrapper and scripts for indicator exclusion procedure}
\usage{
ind_excl(indicators, indicators2 = vector(), outcome, covars = NULL,
  scalename = "scale", outcomename = "outcome",
  indicatornames = 1:ncol(indicators), pcrit, location1 = "topleft",
  location2 = "topright", draw = F, subset = vector(),
  coruse = "everything", multi = 1, verbose = F, ci = "estimate")
}
\arguments{
\item{indicators}{Set of numeric indicators (items) in a matrix.}

\item{indicators2}{An additional set of indicators (e.g. informant-report )}

\item{outcome}{A numeric outcome vector. Indicators and outcome can be simulated with
\code{\link{scale_sim}}}

\item{covars}{A data frame with covariates to take into account. The outcome is residualised for
these covariates. For instance, BMI was residualised for age, gender, and education in Vainik
et al. (2015) EJP.}

\item{scalename}{A string for labelling the scale}

\item{outcomename}{A string for labelling the outcome}

\item{indicatornames}{An array of strings for labelling the outcome. Default to numbers
from 1 to n of indicators}

\item{pcrit}{a p-value characterising the ‘significance’ of difference between
correlations—here called ‘significance of indicator exclusion’ (SONE). Look it up
from Table 2 in Vainik, Mõttus et al 2015, or simulate using
 \code{\link{optimal_p}} function}

\item{location1}{Location for legends at left-side plot}

\item{location2}{Location for legends at right-side plot}

\item{draw}{TRUE plots the result to a .tiff file in the working directory.
Defaults to FALSE}

\item{subset}{Allows exluding certain indicators from the start. Use numbers}

\item{coruse}{argument for function cor(). Defaults to 'everything', as
simulations have no missing data.}

\item{multi}{influences cex of certain plot variables. Defaults to 1}

\item{verbose}{option for observing steps for debugging. Defaults to FALSE}

\item{ci}{should output object and plot have 95% confidence intervals (CI-s). Defaults to
CI-s from  \code{\link[psych]{corr.test}}. If you insert a number (e.g., ci=5000), then the CI-s
are bootstrapped using \code{\link[psych]{cor.ci}}. Any other string results in no CI-s.
r value in output matrix is taken from \code{\link[stats]{cor}}.}
}
\value{
Plots results using , using \code{\link[gplots]{barplot2}} from  \pkg{gplots}.
Also returns scale-outcome correlation magnitude(s) and their comparison, if
 appropriate
}
\description{
For each item, correlation between the scale's sum scores and outcome is
calculated such that the particular item is excluded from the sum scores. Each of the
obtained correlations will then be compared with the original scale–outcome correlation
(sum score of all items). This comparison can be conducted with William's test for two
dependent correlations that share one variable (Steiger, 1980), using
\code{\link[psych]{r.test}} from \pkg{psych}. William's test characterises difference
between correlations with a p-value—a small p-value indicates that the tested
difference between correlations is unlikely to have happened by chance and could be
considered a real difference. Thus, each item will receive a p-value characterising
the 'significance' of difference between correlations—here called 'Significance Of
iNdicator Exclusion' (SONE). When one item is excluded, another round is begun
until no more items should be excluded.
}
\examples{
### Create a scale-outcome set that violates IOn_ Only 2 indicators out of 8
### relate to the outcome, the others just relate to the 2 indicators. This setting is
### similar to the N5: Impulsiveness - BMI association in Vainik et al (2015) EJP paper.
set.seed(466)
a<-scale_sim(n=2500, to_n=2, tn_n=6)
# Last 2 indicators have considerably higher correlation with the outcome
ind_excl(a[[1]], outcome=a[[2]], pcrit=0.0037)

## boostrapped confidence intervals
ind_excl(a[[1]], outcome=a[[2]], pcrit=0.0037, ci=100)

# no confidence intervals
ind_excl(a[[1]], outcome=a[[2]], pcrit=0.0037, ci="no")

## include covariates in the model
covx=rnorm(2500)
covy=rnorm(2500)
outcome=a[[2]]+0.3*covx+0.4*covy
covars=data.frame(covx=covx, covy=covy)

# ind_excl() with covariates taken into account
ind_excl(a[[1]],outcome=outcome,covars=covars, pcrit=0.0037)

#effect sizes are lower when noisy covariatse are not accounted for
ind_excl(a[[1]],outcome=outcome, pcrit=0.0037)

# just a single covariate also needs to be in data frame

covx=rnorm(2500)
outcome=a[[2]]+0.3*covx
covars=data.frame(covx=covx)

ind_excl(a[[1]],outcome=outcome,covars=covars, pcrit=0.0037)

### Create a scale-outcome set that has ION, all 8 indicators relate to the outcome
set.seed(466)
b<-scale_sim(n=2500, to_n=8, cor_to_outcome = 0.35)
# All indicators correlate largely on the same level with the outcome.
ind_excl(b[[1]], outcome=b[[2]], pcrit=1.7*10^-4)

#note that using cor_to_outcome=0.25, sometimes still indicators get wrongly flagged.
# Here, the method could probably be improved..

### Create a scale-outcome set that violates ION - only 1 indicator relates to the
### outcome. Include other-report.
set.seed(466)
c<-scale_sim(n=2500, to_n=1, tn_n=7, indicators2=TRUE)
# Last indicator has considerably higher correlation with the outcome
ind_excl(c[[1]], c[[3]], outcome=c[[2]], pcrit=0.0037)
}

