% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vector_transpose.R
\name{vector_transpose_longer}
\alias{vector_transpose_longer}
\alias{vector_transpose}
\title{Transpose a vector to a long form}
\usage{
vector_transpose_longer(
  data_table,
  names_to = "nace_r2",
  values_to = "value",
  key_column_name = NULL,
  .keep = FALSE
)

vector_transpose(
  data_table,
  names_to = "nace_r2",
  values_to = "value",
  key_column_name = NULL,
  .keep = FALSE
)
}
\arguments{
\item{data_table}{A matrix or vector that normally has a key column.}

\item{names_to}{Defaults to \code{'nace_r2'}.}

\item{values_to}{Defaults to \code{'value'}.}

\item{key_column_name}{The name of the first column. Defaults to \code{NULL} when it is not changed.
It should usually match the key column of the matrix or vector you would like to join the new 
vector created with \code{vector_transpose_longer}.}

\item{.keep}{Keep the indicator identifier column? Defaults to \code{FALSE}.}
}
\value{
A long form vector with a key column, and optionally the identifier of the indicator in
the first column.
}
\description{
Many vectors (indicators, multipliers) are create in the wide form to conform matrixes in 
analytical functions.  For printing it is more useful to have them in long form.
}
\details{
This is a wrapper around \code{\link[tidyr]{pivot_longer}} so you do not necessarily need to
import or load the entire \emph{tidyr} package.
}
\examples{
vector_transpose_longer(
  data.frame(indicator = "my_inidcator", 
             agriculture = 0.0123,
             manufacturing = 0.1436,
             trade = 0.0921)
)
}
\seealso{
Other iotables processing functions: 
\code{\link{conforming_vector_create}()},
\code{\link{household_column_get}()},
\code{\link{iotable_year_get}()},
\code{\link{key_column_create}()},
\code{\link{matrix_round}()},
\code{\link{output_get}()},
\code{\link{primary_input_get}()},
\code{\link{rows_add}()},
\code{\link{supplementary_add}()},
\code{\link{total_tax_add}()},
\code{\link{vector_transpose_wider}()}
}
\concept{iotables processing functions}
