% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/within_network.R
\name{address_in_network}
\alias{address_in_network}
\alias{is_within}
\alias{is_within_any}
\title{Network membership of addresses}
\usage{
is_within(address, network)

is_within_any(address, network)
}
\arguments{
\item{address}{An \code{\link{ip_address}} vector}

\item{network}{An \code{\link{ip_network}} vector}
}
\value{
A logical vector
}
\description{
These functions check whether an address falls within a network.

\code{is_within()} performs a one-to-one matching between addresses and networks.

\code{is_within_any()} checks if each address falls within \emph{any} of the networks.
}
\examples{
is_within(ip_address("192.168.2.6"), ip_network("192.168.2.0/28"))

is_within(ip_address("192.168.3.6"), ip_network("192.168.2.0/28"))

is_within_any(ip_address("192.168.3.6"), ip_network(c("192.168.2.0/28", "192.168.3.0/28")))
}
\seealso{
Use \code{\link[=is_subnet]{is_subnet()}} to check if an \code{\link{ip_network}} is within another
\code{\link{ip_network}}.
}
