% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sql_varname.R
\name{get_sql_varname}
\alias{get_sql_varname}
\title{get_sql_varname}
\usage{
get_sql_varname(question_code, survey_id)
}
\arguments{
\item{question_code}{Code by which to identify the question.
Follows a dot-based naming scheme:
<group title>.<subquestion title>.}

\item{survey_id}{Survey-ID of the survey from which to select the question.}
}
\value{
`character` object containing the field name
}
\description{
Get the internal SQL field name (e.g. "697929X4X21") to a
question from a specific survey in the dataset.
}
\examples{
# This example assumes a locally hosted `LimeSurvey` instance using a locally
# hosted MySQL server.
# On this `LimeSurvey` instance, there is a survey with the ID 123456.
# In this survey, a multiple-choice question identified by the code "bdi.01"
# is used.
# For this question, this example retrieves name of the SQL table field in
# which `LimeSurvey` internally stores the responses to this question.
\dontrun{
connect_to_limesurvey(
  api_url = 'https://localhost/index.php/admin/remotecontrol',
  limesurvey_username = 'admin',
  limesurvey_password = '1234admin',
  mysql_host = '127.0.0.1',
  mysql_port = 3306,
  mysql_dbname = 'limesurvey',
  mysql_username = 'lime',
  mysql_password = '1234lime'
)

q_varname <- get_sql_varname("bdi.01", 123456)
}

}
