% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vary.R
\name{vary}
\alias{vary}
\title{Extract the variance of the responses}
\usage{
vary(object)
}
\arguments{
\item{object}{An object of class \code{ipriorMod} or \code{ipriorKernel}.}
}
\description{
Extract the variance of the responses, \eqn{\mathbf V_y}, of a fitted I-prior
model.
}
\details{
For an I-prior model, the variance is given by \deqn{\mathbf V_y = \psi\mathbf H_\lambda^2 + \psi^{-1}\mathbf I_n}.
}
\examples{
mod.fit <- iprior(stack.loss ~ ., stackloss)
Var.Y <- vary(mod.fit)
str(Var.Y)

}
