% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clt_illustrates.R
\name{see_the_clt_for_uniform}
\alias{see_the_clt_for_uniform}
\title{Illustration of the central limit theorem for sampling from the 
uniform distribution}
\usage{
see_the_clt_for_uniform(nsize = 10, nrep = 10000)
}
\arguments{
\item{nsize}{Sample size, n. Its default value is 10.}

\item{nrep}{Number of replications. How many samples of size \code{nsize} 
should be taken, default value is 10000.}
}
\value{
A vector of means of the replicated samples.  The function also 
has the side effect of drawing a histogram of the sample means and 
two superimposed density functions: one estimated from the data using 
the \code{density} function and the other is the density of the CLT 
approximated normal distribution. The better the CLT approximation, the 
closer are the two superimposed densities.
}
\description{
Illustration of the central limit theorem for sampling from the 
uniform distribution
}
\examples{
a <- see_the_clt_for_uniform()
old.par <- par(no.readonly = TRUE) 
par(mfrow=c(2, 3))
a1 <- see_the_clt_for_uniform(nsize=1)
a2 <- see_the_clt_for_uniform(nsize=2)
a3 <- see_the_clt_for_uniform(nsize=5)
a4 <- see_the_clt_for_uniform(nsize=10)
a5 <- see_the_clt_for_uniform(nsize=20)
a6 <- see_the_clt_for_uniform(nsize=50)
par(old.par)
ybars <- see_the_clt_for_uniform(nsize=12)
zbars <- (ybars - mean(ybars))/sd(ybars)
k <- 100
u <- seq(from=min(zbars), to= max(zbars), length=k)
ecdf <-  rep(NA, k)
for(i in 1:k) ecdf[i] <- length(zbars[zbars<u[i]])/length(zbars)
tcdf <- pnorm(u)
plot(u, tcdf, type="l", col="red", lwd=4, xlab="", ylab="cdf")
lines(u, ecdf, lty=2, col="darkgreen", lwd=4)
symb <- c("cdf of sample means", "cdf of N(0, 1)")
legend(x=-3.5, y=0.4, legend = symb, lty = c(2, 1), 
col = c("darkgreen","red"), bty="n")

}
