% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{search_iptmnet}
\alias{search_iptmnet}
\title{Search iPTMNet}
\usage{
search_iptmnet(search_term, term_type, role, ptm_vector = c(),
  organism_vector = c())
}
\arguments{
\item{search_term}{A string representing the search Term}

\item{term_type}{A string specifying type of search term. Supported values are "All", "UniprotID", "Protein/Gene Name","PMID".
Use the \link{TermType} function for getting a list of possible values.}

\item{role}{A string representing the roles to filter by.
Supported Values are "Enzyme or Substrate", "Enzyme", "Substrate","Enzyme and Substrate".
Use the \link{Role} function for getting a list of possible values.
Example - \code{TermType()$.UniProtID}}

\item{ptm_vector}{A vector representing the PTM types to filter by.
Use the \link{PTMTypes} function for getting a list of possible values. Pass empty vector if you don't want filter by PTMTypes.
Example - c(PTMType()$Acetylation,PTMType()$Phosphorylation)}

\item{organism_vector}{A vector of integers representing the taxon codes for organisms to filter by.}
}
\value{
A dataframe with search results.
}
\description{
Searches the iPTMNet database with the given search parameters
}
\examples{
\dontrun{
result <- search_iptmnet(search_term = "smad2",
                                        term_type=TermType()$ALL,
                                        Role()$EnzymeOrSubstrate,
                                        ptm_vector=c(),
                                        organism_vector=c())
}
}
