% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lbl_helpers.r
\name{lbl_collapse}
\alias{lbl_collapse}
\title{Collapse labelled values to labels that already exist}
\usage{
lbl_collapse(x, .fun)
}
\arguments{
\item{x}{A \code{\link[haven]{labelled}} vector}

\item{.fun}{A function that takes .val and .lbl (the values and
labels) and returns the values of the label you want to change it to.
It is passed to a function similar to \code{\link[rlang]{as_function}}, so
also accepts quosure-style lambda functions (that use values .val and .lbl).
See examples for more information.}
}
\value{
A haven::labeled vector
}
\description{
Converts values to a new value based on their label and value in a
\code{\link[haven]{labelled}} vector. If the newly assigned value does
not match an already existing labelled value, the smallest value's label
is used. Ignores any value that does not have a label.
}
\examples{
x <- haven::labelled(
  c(10, 10, 11, 20, 30, 99, 30, 10),
  c(Yes = 10, `Yes - Logically Assigned` = 11, No = 20, Maybe = 30, NIU = 99)
)

lbl_collapse(x, ~(.val \%/\% 10) * 10)
# Notice that 90 get's NIU from 99 even though 90 didn't have a label in original

lbl_collapse(x, ~ifelse(.lbl == 10, 11, .lbl))
# But here 10 is assigned 11's label

# You can also use the more explicit function notation
lbl_collapse(x, function(.val, .lbl) (.val \%/\% 10) * 10)

# Or even the name of a function
collapse_function <- function(.val, .lbl) (.val \%/\% 10) * 10
lbl_collapse(x, "collapse_function")

}
\seealso{
Other lbl_helpers: \code{\link{lbl_add}},
  \code{\link{lbl_clean}}, \code{\link{lbl_na_if}},
  \code{\link{lbl_relabel}}, \code{\link{lbl}},
  \code{\link{zap_ipums_attributes}}
}
