% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genENgram.R
\name{genENgram}
\alias{genENgram}
\title{generate SMILES strings from extended N-gram model}
\usage{
genENgram(nsmis, engram, order, gentype = "ML", crange = c(10, 100))
}
\arguments{
\item{nsmis}{number of generating SMILES strings}

\item{engram}{ENgram object}

\item{order}{n in ENgram model}

\item{gentype}{Back-off procedure with "ML" option and Neaser-Nay smoothing with "KN" option}

\item{crange}{range in the length of output SMILES strings}
}
\description{
generate SMILES strings from extended N-gram model
}
\examples{
data(engram_5k)
smiles <- genENgram(4, engram_5k, 10)
viewstr(smiles)

}

