% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_hiscores.R
\name{get_hiscores}
\alias{get_hiscores}
\title{get chemical structures with high QSPR score from SmcChem object}
\usage{
get_hiscores(smchem, nsmi = 50, exsim = 0.8)
}
\arguments{
\item{smchem}{SmcChem class object}

\item{nsmi}{maximum number of SMILES strings obtained}

\item{exsim}{excluding structures that are similar with already chosen structures in that the Tanimoto coefficient >= exsim}
}
\description{
get chemical structures with high QSPR scores from the SmcChem object after excluding similar structures
}
\examples{
data(engram_5k) 
data(qsprpred_EG_5k)
smchem <- SmcChem$new(smis = rep("c1ccccc1O", 25), v_qsprpred=qsprpred_EG_5k,
                     v_engram=engram_5k,temp=3)
smcexec(smchem,10)
res <- get_hiscores(smchem, exsim=0.8)
viewstr(res[1:4, 1])

}

