% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ops.R
\name{ir_multiply}
\alias{ir_multiply}
\title{Multiply infrared spectra or multiply infrared spectra with a numeric value}
\usage{
ir_multiply(x, y)
}
\arguments{
\item{x}{An object of class \code{\link[=ir_new_ir]{ir}}.}

\item{y}{An object of class \code{\link[=ir_new_ir]{ir}} or a numeic value. If \code{y}
is an object of class \code{ir}, it must have the same number of rows as
\code{x} and the same x axis values (e.g. wavenumber values) in each matching
spectrum as in \code{x}.}
}
\value{
\code{x} where for each spectrum intensity values are multiplied with
the respective intensity values in \code{y} (if \code{y} is an object of
class \code{ir}), or where all intensity values are multiplied with \code{y}
if \code{y} is a numeric value.
}
\description{
\code{ir_multiply} takes two objects of class \code{ir}, \code{x} and
\code{y}, and multiplies their intensity values, or it takes one object of
class \code{ir}, \code{x}, and one numeric value, \code{y}, and multiplies
all intensity values in \code{x} with \code{y}.
}
\examples{
# multiplication with y as ir object
x1 <-
  ir::ir_multiply(ir::ir_sample_data, ir::ir_sample_data)
x1 <-
  ir::ir_multiply(ir::ir_sample_data, ir::ir_sample_data[1, ])

# multiplication with y being a numeric value
x2 <-
  ir::ir_multiply(ir::ir_sample_data, y = -1)

}
