% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ops.R
\name{ir_divide}
\alias{ir_divide}
\title{Divide infrared spectra or divide infrared spectra by a numeric value}
\usage{
ir_divide(x, y)
}
\arguments{
\item{x}{An object of class \code{\link[=ir_new_ir]{ir}}.}

\item{y}{An object of class \code{\link[=ir_new_ir]{ir}} or a numeic value. If \code{y}
is an object of class \code{ir}, it must have the same number of rows as
\code{x} and the same x axis values (e.g. wavenumber values) in each matching
spectrum as in \code{x}.}
}
\value{
\code{x} where for each spectrum intensity values are divided by
the respective intensity values in \code{y} (if \code{y} is an object of
class \code{ir}), or where all intensity values are divided by \code{y} if
\code{y} is a numeric value.
}
\description{
\code{ir_divide} takes two objects of class \code{ir}, \code{x} and
\code{y}, and divides their intensity values, or it takes one object of
class \code{ir}, \code{x}, and one numeric value, \code{y}, and divides
all intensity values in \code{x} by \code{y}.
}
\examples{
# division with y as ir object
x1 <-
  ir::ir_divide(ir::ir_sample_data, ir::ir_sample_data)
x2 <-
  ir::ir_divide(ir::ir_sample_data, ir::ir_sample_data[1, ])

# division with y being a numeric value
x3 <-
  ir::ir_divide(ir::ir_sample_data, y = 20)

# division with y being a numeric vector
x4 <-
  ir::ir_divide(
     ir::ir_sample_data,
     seq(from = 0.1, to = 2, length.out = nrow(ir::ir_sample_data))
  )

}
