% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_by_configuration.R
\name{summarise_by_configuration}
\alias{summarise_by_configuration}
\title{Summarise by configuration}
\usage{
summarise_by_configuration(
  irace_results,
  elites_only = FALSE,
  instances = c("both", "train", "test")
)
}
\arguments{
\item{irace_results}{The data generated when loading the \code{.Rdata} file created by \code{irace} (or the filename of that file).}

\item{elites_only}{(\code{logical(1)}) If TRUE, only report the final elite configurations.}

\item{instances}{(\code{character(1)}) Select data from the training instances (\code{"train"}) or from the test instances if available (\code{"test"}). The default is from both (\code{"both"}).}
}
\value{
tibble
}
\description{
Summarise by configuration
}
\examples{
irace_results <- read_logfile(system.file(package="irace", "exdata",
                                         "irace-acotsp.Rdata", mustWork = TRUE))
summarise_by_configuration(irace_results, instances = "train", elites_only = TRUE)
}
