% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters_summarise.R
\name{parameters_summarise}
\alias{parameters_summarise}
\title{Summarise parameters space}
\usage{
parameters_summarise(parameters)
}
\arguments{
\item{parameters}{(\code{list()}) Parameter space in irace format. See the function \code{\link[irace:readParameters]{irace::readParameters()}}.}
}
\value{
\code{\link[tibble:tibble]{tibble::tibble()}}
}
\description{
Summarise parameters space
}
\examples{
# Read the parameters directly from text.
parameters_tab <- '
a "" i (2, 10)
b "" c (yes, no) | a < 5
c "" o (low, medium, high) | (a == 2) | (b == "yes")
d "" r (a, 50)'
parameters <- irace::readParameters(text=parameters_tab)
parameters_summarise(parameters)

}
\author{
Manuel López-Ibáñez
}
