% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ar1_sim_conditional_cpp}
\alias{ar1_sim_conditional_cpp}
\title{Simulate from a stationary Gaussian AR(1) process.}
\usage{
ar1_sim_conditional_cpp(pred_times, mu_pred, x_obs, obs_times, mu_obs, rho,
  sigma)
}
\arguments{
\item{pred_times}{A vector of time points to simulate at.}

\item{x_obs}{The observed values of the process.}

\item{obs_times}{A vector of time points at which observations have been
made.}

\item{rho}{A real number strictly less than 1 in absolute value.}

\item{sigma}{A positive real number.}
}
\value{
A vector of length \code{length(pred_times)} with the process
  values.
}
\description{
Simulate from a stationary Gaussian AR(1) process at \code{n} consecutive
time points.
}
\keyword{internal}
