% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_objects.R
\name{generate_resp_set}
\alias{generate_resp_set}
\title{Generate a random item responses (Response_set object)}
\usage{
generate_resp_set(ip, theta, prop_missing = 0)
}
\arguments{
\item{ip}{An \code{\link{Item-class}}, \code{\link{Itempool-class}},
\code{\link{Testlet-class}} object containing the item parameters.}

\item{theta}{An object containing the subject ability parameters.}

\item{prop_missing}{Proportion of responses that should be missing. Default
value is \code{0}.}
}
\value{
Returns a \code{\link{Response_set-class}} object.
}
\description{
\code{generate_resp_set} Generate dichotomous (0 or 1) or polytomous
responses for given ability and item parameter(s). This function returns a
\code{\link{Response_set-class}} object,
}
\examples{
ip <- generate_ip(model = "3PL", n = 15)
generate_resp_set(ip, theta = rnorm(5))

# Set the proportion of missing responses:
generate_resp_set(ip, theta = rnorm(7), prop_missing = 0.3)

}
\author{
Emre Gonulates
}
