% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dif.R
\name{area_between_icc}
\alias{area_between_icc}
\title{Calculate the area between two ICC curves}
\usage{
area_between_icc(
  ...,
  type = c("closed", "exact"),
  theta_range = c(-5, 5),
  signed_area = FALSE
)
}
\arguments{
\item{...}{An \code{\link{Itempool-class}} object; or a combination of
\code{\link{Item-class}} and \code{\link{Testlet-class}} objects.}

\item{type}{A string representing the method that will be used to calculate
the area between two ICC curves. Available values are:
\describe{
  \item{\code{"exact"}}{The exact area between the whole theta scale
    \code{-Inf} and \code{Inf}. This method implements Raju's (1988)
    approach. When the pseudo-guessing parameters of the items differ
    for '3PL' model, the area will be infinity. See Raju (1988) for
    details.}
  \item{\code{"closed"}}{The area within a closed interval defined by
    \code{theta_range} argument will be calculated. This method always
    returns a finite value. See Kim and Cohen (1991) for details.}
}
The default method is \code{"closed"}.}

\item{theta_range}{A numeric vector of length two with the first element
smaller than the second element. The values define the boundaries in which
the area between two ICC's will be calculated. The default value is
\code{c(-5, 5)}.}

\item{signed_area}{A logical value for whether the signed or unsigned area
between two curves will be calculated. When \code{signed = TRUE}, the
area under the second item is subtracted from the area under the first
item. The result can be negative if the first item is mostly under
the second item. When \code{signed = FALSE}, the distance between two ICC
curves will be calculated. The default value is \code{signed = TRUE}.}
}
\value{
A matrix where the values in cells are the areas between items.
  The rows represent the first item and the columns represents the second
  item and the area of second item is subtracted from the first item when
  "signed" area is desired. For example, the value corresponding to the cell
  where row is for "Item_4" and column is for "Item_2", the value in the cell
  is the area of "Item_4 - Item_2".
}
\description{
This function calculates the area between two item
  characteristic curves (ICC) for unidimensional dichotomous IRT models.

  There are two types of area calculation methods. The first one is
  \code{type = "exact"} where the exact area from negative infinity to
  positive infinity between the two ICC curves will be calculated.
  This method implements the approach in Raju's 1988 paper. This
  method works for 'Rasch', '1PL', '2PL', '3PL' models but when the
  pseudo-guessing parameters of the items differ for '3PL' model, the
  area will be infinity. In such cases it is advisable to use
  \code{type = "closed"}.

  The area can only be calculated for 'Rasch', '1PL', '2PL', '3PL' or
  '4PL' models.
}
\examples{
# Closed area example:
ip <- generate_ip(model = c("3PL", "3PL", "3PL"))
# plot(ip) # See the ICCs
area_between_icc(ip, type = "closed")
area_between_icc(ip, type = "closed", signed_area = TRUE)

# The result is infinite because 'c' parameters are not equal
area_between_icc(ip, type = "exact")

# Exact area example:
ip <- generate_ip(model = c("2PL", "2PL", "2PL"))
area_between_icc(ip, type = "exact")
area_between_icc(ip, type = "exact", signed_area = TRUE)
# The 'closed' area is very close to the 'exact' area with a wide theta range
area_between_icc(ip, type = "closed", theta_range = c(-10, 10))

}
\references{
Kim, S.-H., & Cohen, A. S. (1991). A comparison of two area measures for
detecting differential item functioning. Applied Psychological Measurement,
15(3), 269–278.

Raju, N. S. (1988). The area between two item characteristic curves.
Psychometrika, 53(4), 495–502.
}
\author{
Emre Gonulates
}
