% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isatools.R
\name{isa_ID_find}
\alias{isa_ID_find}
\title{Find IDs of nodes or properties}
\usage{
isa_ID_find(x, node_pattern = NULL, value_pattern = NULL, prop_pattern = NULL)
}
\arguments{
\item{x}{object of class isatab}

\item{node_pattern}{return only nodes which match the given pattern}

\item{value_pattern}{return only nodes which match one of the values}

\item{prop_pattern}{return only nodes which match one of the properties}
}
\value{
Character vector of IDs
}
\description{
Find IDs of nodes or properties fullfilling specified criteria
}
\details{
Note: IDs are a thing internal to this R package. They are not imported
from or exported to actual ISA-tab files. However, given that the node
'identifiers' (e.g. 'Sample Name') can be ambiguous, IDs are necessary
to unambiguously identify a node.
}
\examples{
file <- system.file('extdata', 
   'a_isatab.txt',
   package='isaeditor')
isa_a <- read_isa(file)
isa_ID_find(isa_a, node_pattern='.* Name')
isa_a[['ID34']]
}
\seealso{
\code{\linkS4class{isatab}}
}
