% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_isco_code.R
\name{get_isco_code}
\alias{get_isco_code}
\title{Get ISCO code}
\usage{
get_isco_code(data, lvl = 3)
}
\arguments{
\item{data, }{data.table with a column named as \code{job}}

\item{lvl, }{numeric value indicating the ISCO taxonomy}
}
\value{
data.table of input data with one extra column named as \code{code}
}
\description{
Adds column of ISCO code for a particular job title. Job titles should be
given in the preferred label of the ISCO classification.
}
\examples{
library(iscoCrosswalks)
# add mandatory column
dat <- foundation_skills[, .(job = preferredLabel, Skill, Value)]
res <- get_isco_code(dat, lvl = 1)
head(res[, .(code, Skill, Value)])
}
