% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{D17O}
\alias{D17O}
\title{Triple oxygen isotope value}
\usage{
D17O(d18O, d17O, lambda = 0.528)
}
\arguments{
\item{d18O}{Isotope delta value (‰).}

\item{d17O}{Isotope delta value (‰).}

\item{lambda}{Triple oxygen isotope reference slope. Default \code{0.528}.}
}
\value{
Returns the D17O value (‰).
}
\description{
\code{D17O()} calculates the D17O value.
}
\details{
\deqn{\Delta^{17}O_{VSMOW} = \delta'^{17}O_{VSMOW} -
\lambda \times \delta'^{18}O_{VSMOW} }
}
\examples{
D17O(d18O = -10, d17O = -5, lambda = 0.528)

}
