% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical_resources_cubes.R
\name{get_datasets_agency_resource_version}
\alias{get_datasets_agency_resource_version}
\title{Get datasets (agencyID / resourceID / version)}
\usage{
get_datasets_agency_resource_version(agencyID, resourceID, version,
  dim = NULL, fields = NULL, lang = "es")
}
\arguments{
\item{agencyID}{(string) Identifier of the maintainer organization of the resource. A possible value is \code{ISTAC}.}

\item{resourceID}{(string) Resource identifier. A possible value is \code{C00010A_000002}.}

\item{version}{(string) Resource version. A possible value is \code{001.000}.}

\item{dim}{(string) Allows filtering the data obtained in the response. A example is \code{TIME_PERIOD:2009|2010}.}

\item{fields}{(string) Allows you to customize the response by excluding fields from it. The possible values are \code{-metadata} and \code{-data}.}

\item{lang}{(string) Language in which you want to get the answer.}
}
\description{
This function allows to obtain all the versions of a statistical cube with a certain identifier and that also maintains a certain organization.
}
\examples{
get_datasets_agency_resource_version(
   agencyID = "ISTAC", resourceID = "C00010A_000002", version = "001.000",
   fields = "-data,-metadata"
)
}
