% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itan.R
\name{analizarItems}
\alias{analizarItems}
\title{An\enc{á}{a}lisis de \enc{í}{i}tems.}
\usage{
analizarItems(respCorregidas, proporcion = 0.27, digitos = 2)
}
\arguments{
\item{respCorregidas}{Una matriz con las respuestas de los estudiantes a cada \enc{í}{i}tem
en forma binaria.}

\item{proporcion}{Proporci\enc{ó}{o}n de estudiantes que forman parte de los grupos superior
e inferior. Valores habituales son 0.25, 0.27 y 0.33.}

\item{digitos}{La cantidad de d\enc{í}{i}gitos significativos que tendr\enc{á}{a} el resultado.}
}
\value{
Una matriz con los \enc{í}{i}tems como filas y los \enc{í}{i}ndices como
columnas.
}
\description{
Calcula el \enc{í}{i}ndice de dificultad y dos tipos de \enc{í}{i}ndices de
discriminaci\enc{ó}{o}n para cada \enc{í}{i}tem a partir de una matriz de respuestas binaria.
}
\details{
El \enc{í}{i}ndice de dificultad p correponde a la proporci\enc{ó}{o}n de estudiantes
que responde correctamente el \enc{í}{i}tem. Puede tomar valores entre 0 y 1.
A mayor valor, el \enc{í}{i}tem es más f\enc{á}{a}cil.

Los \enc{í}{i}ndices de discriminaci\enc{ó}{o}n permiten determinar si el \enc{í}{i}tem diferencia
entre estudiantes con alta o baja habilidad. Se calculan a partir del
grupo de estudiantes con mejor y peor puntuaci\enc{ó}{o}n en el test.

El \enc{í}{i}ndice de discriminaci\enc{ó}{o}n 1 (Dc1) corresponde a la diferencia entre
la proporci\enc{ó}{o}n de aciertos del grupo superior y la proporci\enc{ó}{o}n de aciertos
del grupo inferior. Los valores extremos que puede alcanzar este \enc{í}{i}ndice
son 0 y +/-1. Los \enc{í}{i}tems con discriminaci\enc{ó}{o}n negativa favorecen a los
estudiantes con baja puntuaci\enc{ó}{o}n en el test y en principio deben ser revisados.
Este \enc{í}{i}ndice se ve influenciado por el \enc{í}{i}ndice de dificultad, por lo que a
veces es conveniente compararlo con el \enc{í}{i}ndice de discriminaci\enc{ó}{o}n 2 (Dc2).

El \enc{í}{i}ndice de discriminaci\enc{ó}{o}n 2 (Dc2) corresponde a la proporci\enc{ó}{o}n de
aciertos del grupo superior en relaci\enc{ó}{o}n al total de aciertos de ambos grupos.
Los valores de este \enc{í}{i}ndice van de 0 a 1. Pueden considerarse satisfactorios
valores mayores a 0.5. Este \enc{í}{i}ndice es independiente del nivel de dificultad
de la pregunta.
}
\examples{
data(datos)
data(clave)
respuestas <- subset(datos, select = -id )
analizarItems(corregirItems(respuestas, clave))

}
\references{
Morales, P. (2009). An\enc{á}{a}lisis de \enc{í}{i}tem en las pruebas objetivas.
Madrid. Recuperado de \url{https://educrea.cl/wp-content/uploads/2014/11/19-nov-analisis-de-items-en-las-pruebas-objetivas.pdf}
}
\seealso{
\code{\link{corregirItems}}, \code{\link{datos}} y \code{\link{clave}}.
}
