% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{fadeRug}
\alias{fadeRug}
\title{Fade out the areas in a surface without data.}
\usage{
fadeRug(x, y, n.grid = 30, gradual = FALSE, max.alpha = 0.75,
  col = "white")
}
\arguments{
\item{x}{Observations on x-axis.}

\item{y}{Observations on y-axis.}

\item{n.grid}{Resolution of Rug. Defaults to 30, 
which means that the x- and y-axis are divided in 30 bins.}

\item{gradual}{Logical: whether or not to use the number of 
observations in an area, i.e., more transparent equals more 
observations. Default is FALSE, which means that the function only 
distinguishes between observations in a certain region or not, 
regardless how many observations.}

\item{max.alpha}{Maximum of transparency, number between 0 (completely 
transparent) and 1 (non-transparent). Defaults to .75.}

\item{col}{Color value. Defaults to "white".}
}
\value{
Plots a shaded image over the contour plot or image.
}
\description{
Add a transparency Rug to a contour plot or image.
}
\section{Warning}{

On Linux \code{\link{x11}} devices may not support transparency. 
In that case, a solution might be to write the plots immediately to a file 
using functions such as \code{\link{pdf}}, or \code{\link{png}}.
}
\examples{
data(simdat)

# Introduce extreme values:
set.seed(123)
newdat <- simdat[sample(which(simdat$Time < 1500),
    size=round(.5*length(which(simdat$Time < 1500)))),]
newdat <- rbind(newdat, 
    simdat[sample(which(simdat$Time > 1500),
    size=5),])
# Some simple GAM with tensor:
m1 <- bam(Y ~ te(Time, Trial), data=newdat)
# plot summed effects:
fvisgam(m1, view=c("Time", "Trial"), zlim=c(-15,15),
    add.color.legend=FALSE)
# add rug:
fadeRug(newdat$Time, newdat$Trial)
# compare with default rug:
rug(newdat$Time)
rug(newdat$Trial, side=2)
# add color legend:
gradientLegend(c(-15,15), pos=.875)
# add data points (for checking the grid):
points(newdat$Time, newdat$Trial)

# change x- and y-grid:
fvisgam(m1, view=c("Time", "Trial"), zlim=c(-15,15))
points(newdat$Time, newdat$Trial)
fadeRug(newdat$Time, newdat$Trial, n.grid=c(100,10), col='gray')
}
\author{
Jacolien van Rij
}
\seealso{
\code{\link[graphics]{rug}}, \code{\link[graphics]{contour}}, 
\code{\link[graphics]{image}}

Other Functions for plotting: \code{\link{addInterval}},
  \code{\link{add_bars}}, \code{\link{alphaPalette}},
  \code{\link{alpha}}, \code{\link{check_normaldist}},
  \code{\link{color_contour}}, \code{\link{dotplot_error}},
  \code{\link{drawArrows}}, \code{\link{emptyPlot}},
  \code{\link{errorBars}}, \code{\link{fill_area}},
  \code{\link{getCoords}}, \code{\link{getFigCoords}},
  \code{\link{getProps}}, \code{\link{gradientLegend}},
  \code{\link{marginDensityPlot}},
  \code{\link{plot_error}}, \code{\link{plot_image}},
  \code{\link{plotsurface}}, \code{\link{rug_model}}
}

