% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shap_spatial_response.R
\name{shap_spatial_response}
\alias{shap_spatial_response}
\title{Calculate shapley values-based spatial response.}
\usage{
shap_spatial_response(
  model,
  var_occ,
  variables,
  target_vars = NULL,
  shap_nsim = 10,
  seed = 10,
  pfun = .pfun_shap
)
}
\arguments{
\item{model}{(\code{isolation_forest} or other model). It could
be the item \code{model} of \code{POIsotree} made by function \code{\link{isotree_po}}.
It also could be other user-fitted models as long as the \code{pfun} can work on it.}

\item{var_occ}{(\code{data.frame}, \code{tibble}) The \code{data.frame} style table that
include values of environmental variables at occurrence locations.}

\item{variables}{(\code{stars}) The \code{stars} of environmental variables.
It should have multiple \code{attributes} instead of \code{dims}.
If you have \code{raster} object instead, you
could use \code{\link{st_as_stars}} to convert it to \code{stars} or use
\code{\link{read_stars}} directly read source data as a \code{stars}.
You also could use item \code{variables} of \code{POIsotree} made by function
\code{\link{isotree_po}}.}

\item{target_vars}{(a \code{vector} of \code{character}) The selected variables to
process. If it is \code{NULL}, all variables will be used.}

\item{shap_nsim}{(\code{integer}) The number of Monte Carlo repetitions in SHAP
method to use for estimating each Shapley value. See details in documentation
of function \code{\link{explain}} in package \code{fastshap}.
When the number of variables is large, a smaller shap_nsim could be used.
Be cautious that making SHAP-based spatial dependence will be slow
because of Monte-Carlo computation for all pixels.
But it is worth the time because it is much more
informative. See details in documentation of function \code{\link{explain}}
in package \code{fastshap}. The default is 10. Usually a value 10 - 20 is enough.}

\item{seed}{(\code{integer}) The seed for any random progress. The default is \code{10L}.}

\item{pfun}{(\code{function}) The predict function that requires two arguments,
\code{object} and \code{newdata}.
It is only required when \code{model} is not \code{isolation_forest}.
The default is the wrapper function designed for iForest model in \code{itsdm}.}
}
\value{
(\code{SHAPSpatial}) A list of
\itemize{
A list of \code{stars} object of spatially SHAP-based response of all variables
}
}
\description{
Calculate spatially SHAP-based response figures.
They can help to diagnose both how and where the species
responses to environmental variables.
}
\details{
The values show how each environmental variable affects the modeling
prediction in space. These maps could help to answer questions of where in
terms of environmental response.
}
\examples{
# Using a pseudo presence-only occurrence dataset of
# virtual species provided in this package
library(dplyr)
library(sf)
library(stars)
library(itsdm)

# Prepare data
data("occ_virtual_species")
obs_df <- occ_virtual_species \%>\% filter(usage == "train")
eval_df <- occ_virtual_species \%>\% filter(usage == "eval")
x_col <- "x"
y_col <- "y"
obs_col <- "observation"

# Format the observations
obs_train_eval <- format_observation(
  obs_df = obs_df, eval_df = eval_df,
  x_col = x_col, y_col = y_col, obs_col = obs_col,
  obs_type = "presence_only")

env_vars <- system.file(
  'extdata/bioclim_tanzania_10min.tif',
  package = 'itsdm') \%>\% read_stars() \%>\%
  slice('band', c(1, 5, 12))

# With imperfect_presence mode,
mod <- isotree_po(
  obs_mode = "imperfect_presence",
  obs = obs_train_eval$obs,
  obs_ind_eval = obs_train_eval$eval,
  variables = env_vars, ntrees = 20,
  sample_size = 0.8, ndim = 2L,
  seed = 123L, response = FALSE,
  spatial_response = FALSE,
  check_variable = FALSE)

shap_spatial <- shap_spatial_response(
  model = mod$model,
  var_occ = mod$vars_train,
  variables = mod$variables,
  shap_nsim = 1)

shap_spatial <- shap_spatial_response(
 model = mod$model,
 target_vars = c("bio1", "bio12"),
 var_occ = mod$vars_train,
 variables = mod$variables,
 shap_nsim = 1)

\dontrun{
##### Use Random Forest model as an external model ########
library(randomForest)

# Prepare data
data("occ_virtual_species")
obs_df <- occ_virtual_species \%>\%
  filter(usage == "train")

env_vars <- system.file(
  'extdata/bioclim_tanzania_10min.tif',
  package = 'itsdm') \%>\% read_stars() \%>\%
  slice('band', c(1, 5, 12)) \%>\%
  split()

model_data <- stars::st_extract(
  env_vars, at = as.matrix(obs_df \%>\% select(x, y))) \%>\%
  as.data.frame()
names(model_data) <- names(env_vars)
model_data <- model_data \%>\%
  mutate(occ = obs_df[['observation']])
model_data$occ <- as.factor(model_data$occ)

mod_rf <- randomForest(
  occ ~ .,
  data = model_data,
  ntree = 200)

pfun <- function(X.model, newdata) {
  # for data.frame
  predict(X.model, newdata, type = "prob")[, "1"]
}

shap_spatial <- shap_spatial_response(
  model = mod_rf,
  target_vars = c("bio1", "bio12"),
  var_occ = model_data \%>\% select(-occ),
  variables = env_vars,
  shap_nsim = 10,
  pfun = pfun)
}

}
\seealso{
\code{\link{spatial_response}}
}
