% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_monobound.R
\name{matchrow}
\alias{matchrow}
\title{Auxiliary function: matching rows in data to a vector}
\usage{
matchrow(data, match)
}
\arguments{
\item{data}{\code{data.frame} whose rows will be compared against a
given vector to determine whether or not they are identical in
values.}

\item{match}{the vector against which \code{data} will be compared
against.}
}
\value{
binary vector, each element indicating whether the
    corresponding row in \code{data} matches the vector
    \code{match}.
}
\description{
For a given vector \code{match}, this function returns a binary
indicator for each row in \code{data}, telling you whether or not
that row matches the entries in the vector \code{match}. Note this
assumes that \code{data} and \code{match} have the same column
order.
}
