% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/audit.R
\name{audit}
\alias{audit}
\title{Audit procedure}
\usage{
audit(data, uname, m0, m1, splinesobj, vars_mtr, terms_mtr0, terms_mtr1,
  vars_data, initgrid.nu = 20, initgrid.nx = 20, audit.nx = 2500,
  audit.nu = 25, audit.add = 100, audit.max = 25,
  audit.grid = NULL, save.grid = FALSE, m1.ub, m0.ub, m1.lb, m0.lb,
  mte.ub, mte.lb, m1.ub.default = FALSE, m0.ub.default = FALSE,
  mte.ub.default = FALSE, m1.lb.default = FALSE,
  m0.lb.default = FALSE, mte.lb.default = FALSE, m0.dec = FALSE,
  m0.inc = FALSE, m1.dec = FALSE, m1.inc = FALSE, mte.dec = FALSE,
  mte.inc = FALSE, sset, gstar0, gstar1, orig.sset = NULL,
  orig.criterion = NULL, criterion.tol = 0, lpsolver, noisy = TRUE,
  seed = 12345, debug = FALSE)
}
\arguments{
\item{data}{\code{data.frame} or \code{data.table} used to estimate
the treatment effects.}

\item{uname}{variable name for the unobservable used in declaring
the MTRs. The name can be provided with or without quotation
marks.}

\item{m0}{one-sided formula for the marginal treatment response
function for the control group. Splines may also be
incorporated using the expression \code{uSpline}, e.g.
\code{uSpline(degree = 2, knots = c(0.4, 0.8), intercept =
TRUE)}. The \code{intercept} argument may be omitted, and is
set to \code{TRUE} by default.}

\item{m1}{one-sided formula for marginal treatment response
function for treated group. Splines can also be incorporated
using the expression "uSplines(degree, knots, intercept)". The
\code{intercept} argument may be omitted, and is set to
\code{TRUE} by default.}

\item{splinesobj}{list of spline components in the MTRs for treated
and control groups. Spline terms are extracted using
\code{\link{removeSplines}}. This object is supposed to be a
dictionary of splines, containing the original calls of each
spline in the MTRs, their specifications, and the index used
for renaming each component.}

\item{vars_mtr}{character, vector of variables entering into
\code{m0} and \code{m1}.}

\item{terms_mtr0}{character, vector of terms entering into
\code{m0}.}

\item{terms_mtr1}{character, vector of terms entering into
\code{m1}.}

\item{vars_data}{character, vector of variables that can be found
in the data.}

\item{initgrid.nu}{integer determining the number of evenly spread
points in the interval [0, 1] of the unobservable \code{u} used
to form the initial constraint grid for imposing shape
restrictions on the MTRs.}

\item{initgrid.nx}{integer determining the number of points of the
covariates used to form the initial constraint grid for
imposing shape restrictions on the MTRs.}

\item{audit.nx}{integer determining the number of points on the
covariates space to audit in each iteration of the audit
procedure.}

\item{audit.nu}{integer determining the number of points in the
interval [0, 1], corresponding to space of unobservable
\code{u}, to audit in each iteration of the audit procedure.}

\item{audit.add}{maximum number of points to add to the initial
constraint grid for imposing each kind of shape constraint. For
example, if there are 5 different kinds of shape constraints,
there can be at most \code{audit.add * 5} additional points
added to the constraint grid.}

\item{audit.max}{maximum number of iterations in the audit
procedure.}

\item{audit.grid}{list, contains the A A matrix used in the audit
for the original sample, as well as the RHS vector used in the
audit from the original sample.}

\item{save.grid}{boolean, set to \code{FALSE} by default. Set to
true if the fine grid from the audit should be saved. This
option is used for inference procedure under partial
identification, which uses the fine grid from the original
sample in all bootstrap resamples.}

\item{m1.ub}{numeric value for upper bound on MTR for the treated
group. By default, this will be set to the largest value of the
observed outcome in the estimation sample.}

\item{m0.ub}{numeric value for upper bound on MTR for the control
group. By default, this will be set to the largest value of the
observed outcome in the estimation sample.}

\item{m1.lb}{numeric value for lower bound on MTR for the treated
group. By default, this will be set to the smallest value of
the observed outcome in the estimation sample.}

\item{m0.lb}{numeric value for lower bound on MTR for the control
group. By default, this will be set to the smallest value of
the observed outcome in the estimation sample.}

\item{mte.ub}{numeric value for upper bound on treatment effect
parameter of interest.}

\item{mte.lb}{numeric value for lower bound on treatment effect
parameter of interest.}

\item{m1.ub.default}{boolean, default set to FALSE. Indicator for
whether the value assigned was by the user, or set by default.}

\item{m0.ub.default}{boolean, default set to FALSE. Indicator for
whether the value assigned was by the user, or set by default.}

\item{mte.ub.default}{boolean, default set to FALSE. Indicator for
whether the value assigned was by the user, or set by default.}

\item{m1.lb.default}{boolean, default set to FALSE. Indicator for
whether the value assigned was by the user, or set by default.}

\item{m0.lb.default}{boolean, default set to FALSE. Indicator for
whether the value assigned was by the user, or set by default.}

\item{mte.lb.default}{boolean, default set to FALSE. Indicator for
whether the value assigned was by the user, or set by default.}

\item{m0.dec}{logical, set to \code{FALSE} by default. Set equal to
\code{TRUE} if the MTR for the control group should be weakly
monotone decreasing.}

\item{m0.inc}{logical, set to \code{FALSE} by default. Set equal to
\code{TRUE} if the MTR for the control group should be weakly
monotone increasing.}

\item{m1.dec}{logical, set to \code{FALSE} by default. Set equal to
\code{TRUE} if the MTR for the treated group should be weakly
monotone decreasing.}

\item{m1.inc}{logical, set to \code{FALSE} by default. Set equal to
\code{TRUE} if the MTR for the treated group should be weakly
monotone increasing.}

\item{mte.dec}{logical, set to \code{FALSE} by default. Set equal
to \code{TRUE} if the MTE should be weakly monotone decreasing.}

\item{mte.inc}{logical, set to \code{FALSE} by default. Set equal
to \code{TRUE} if the MTE should be weakly monotone increasing.}

\item{sset}{a list containing the point estimates and gamma}

\item{gstar0}{set of expectations for each terms of the MTR for the
control group.}

\item{gstar1}{set of expectations for each terms of the MTR for the
control group.}

\item{orig.sset}{list, only used for bootstraps. The list caontains
the gamma moments for each element in the S-set, as well as the
IV-like coefficients.}

\item{orig.criterion}{numeric, only used for bootstraps. The scalar
corresponds to the minimum observational equivalence criterion
from the original sample.}

\item{criterion.tol}{tolerance for violation of observational
equivalence, set to 0 by default. Statistical noise may
prohibit the theoretical LP problem from being feasible. That
is, there may not exist a set of coefficients on the MTR that
are observationally equivalent with regard to the IV-like
regression coefficients. The function therefore first estimates
the minimum violation of observational equivalence. This is
reported in the output under the name 'minimum criterion'. The
constraints in the LP problem pertaining to observational
equivalence are then relaxed by the amount \code{minimum
criterion * (1 + criterion.tol)}. Set \code{criterion.tol} to a
value greater than 0 to allow for more conservative bounds.}

\item{lpsolver}{character, name of the linear programming package
in R used to obtain the bounds on the treatment effect. The
function supports \code{'gurobi'}, \code{'cplexapi'},
\code{'lpsolveapi'}.}

\item{noisy}{boolean, default set to \code{TRUE}. If \code{TRUE},
then messages are provided throughout the estimation
procedure. Set to \code{FALSE} to suppress all messages,
e.g. when performing the bootstrap.}

\item{seed}{integer, the seed that determines the random grid in
the audit procedure.}

\item{debug}{boolean, indicates whether or not the function should
provide output when obtaining bounds. The option is only
applied when \code{lpsolver = 'gurobi'}. The output provided is
the same as what the Gurobi API would send to the console.}
}
\value{
a list. Included in the list is the minimum violation of
    observational equivalence of the set of IV-like estimands, as
    well as the list of matrices and vectors associated with
    solving the LP problem.
}
\description{
This is the wrapper for running the entire audit procedure. This
function sets up the LP problem of minimizing the violation of
observational equivalence for the set of IV-like estimands, while
satisfying boundedness and monotonicity constraints declared by the
user. Rather than enforce boundedness and monotonicity hold across
the entire support of covariates and unobservables, this procedure
enforces the conditions over a subset of points in a grid. This
grid corresponds to the set of values the covariates can take, and a
subset of values of the unobservable term. The size of this grid is
specified by the user in the function arguments. The procedure then
goes on to check whether the constraints are satisfied at points
off the grid. Any point where either the boundedness or
monotonicity constraints are violated are incorporated into the
grid, and the process is repeated until the grid incorporates the
entire support of the covariates, or until some a maximum number of
iterations is reached.
}
\examples{
dtm <- ivmte:::gendistMosquito()

## Declare empty list to be updated (in the event multiple IV like
## specifications are provided
sSet <- list()

## Declare MTR formulas
formula1 = ~ 1 + u
formula0 = ~ 1 + u

## Construct object that separates out non-spline components of MTR
## formulas from the spline components. The MTR functions are
## obtained from this object by the function 'genSSet'
splinesList = list(removeSplines(formula0), removeSplines(formula1))

## Construct MTR polynomials
polynomials0 <- polyparse(formula = formula0,
                 data = dtm,
                 uname = u,
                 as.function = FALSE)

polynomials1 <- polyparse(formula = formula0,
                 data = dtm,
                 uname = u,
                 as.function = FALSE)

## Generate propensity score model
propensityObj <- propensity(formula = d ~ z,
                            data = dtm,
                            link = "linear")

## Generate IV estimates
ivEstimates <- ivEstimate(formula = ey ~ d | z,
                          data = dtm,
                          components = l(intercept, d),
                          treat = d,
                          list = FALSE)

## Generate target gamma moments
targetGamma <- genTarget(treat = "d",
                         m0 = ~ 1 + u,
                         m1 = ~ 1 + u,
                         target = "atu",
                         data = dtm,
                         splinesobj = splinesList,
                         pmodobj = propensityObj,
                         pm0 = polynomials0,
                         pm1 = polynomials1,
                         point = FALSE)

## Construct S-set, which contains the coefficients and weights
## corresponding to various IV-like estimands
sSet <- genSSet(data = dtm,
                sset = sSet,
                sest = ivEstimates,
                splinesobj = splinesList,
                pmodobj = propensityObj$phat,
                pm0 = polynomials0,
                pm1 = polynomials1,
                ncomponents = 2,
                scount = 1,
                yvar = "ey",
                dvar = "d",
                means = TRUE)

## Perform audit procedure and return bounds
audit(data = dtm,
      uname = u,
      m0 = formula0,
      m1 = formula1,
      splinesobj = splinesList,
      vars_data = colnames(dtm),
      vars_mtr = "u",
      terms_mtr0 = "u",
      terms_mtr1 = "u",
      sset = sSet$sset,
      gstar0 = targetGamma$gstar0,
      gstar1 = targetGamma$gstar1,
      m0.inc = TRUE,
      m1.dec = TRUE,
      m0.lb = 0.2,
      m1.ub = 0.8,
      audit.max = 5,
      lpsolver = "lpSolveAPI")

}
