% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivo_tables.R
\encoding{UTF-8}
\name{ivo_table_add_mask}
\alias{ivo_table_add_mask}
\title{Add masking (censoring) to a table}
\usage{
ivo_table_add_mask(df, cell = 5)
}
\arguments{
\item{df}{A data frame containing a column called "Freq", e.g. a frequency table created using \code{ftable(exclude=NULL) |> data.frame()}.}

\item{cell}{The cell count at which masking should be used. Cell counts between 1 and this number will be masked. The default is 5.}
}
\value{
A data frame with masked cell counts.
}
\description{
Table masking using cell counts..
}
\details{
Masking is used to prevent the distribution of tables where individuals could be identified.
}
\examples{

library(dplyr)
example_data <- data.frame(Year = sample(2020:2023, 50, replace = TRUE),
A = sample(c("Type 1", "Type 2"), 50, replace = TRUE),
B = sample(c("Apples", "Oranges", "Bananas"), 50, replace = TRUE),
C = sample(c("Swedish", "Norwegian", "Chilean"), 50, replace = TRUE))
# With masking limit set at 7:
example_data |> select(Year, A) |>
  ftable(exclude=NULL) |>
  data.frame() |>
  ivo_table_add_mask(cell = 7)

}
\seealso{
{ivo_table_masked} for masked tables.
}
\author{
Måns Thulin
}
