% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/between.R
\name{iv_count_between}
\alias{iv_count_between}
\title{Count when a vector falls between an iv}
\usage{
iv_count_between(needles, haystack, ..., missing = "equals", no_match = 0L)
}
\arguments{
\item{needles}{\verb{[vector, iv]}

\code{needles} should be a vector and \code{haystack} should be an iv. \code{needles}
should have the same type as the start/end components of \code{haystack}.
\itemize{
\item Each element of \code{needles} represents the value to search for.
\item \code{haystack} represents the intervals to search in.
}}

\item{haystack}{\verb{[vector, iv]}

\code{needles} should be a vector and \code{haystack} should be an iv. \code{needles}
should have the same type as the start/end components of \code{haystack}.
\itemize{
\item Each element of \code{needles} represents the value to search for.
\item \code{haystack} represents the intervals to search in.
}}

\item{...}{These dots are for future extensions and must be empty.}

\item{missing}{\verb{[integer(1) / "equals" / "error"]}

Handling of missing values in \code{needles}.
\itemize{
\item \code{"equals"} considers missing values in \code{needles} as exactly equal
to missing intervals in \code{haystack} when determining if there is a
matching relationship between them.
\item \code{"error"} throws an error if any values in \code{needles} are missing.
\item If a single integer value is provided, this represents the count returned
for a missing value in \code{needles}. Use \code{0L} to force missing values
to never match.
}}

\item{no_match}{\verb{[integer(1) / "error"]}

Handling of \code{needles} without a match.
\itemize{
\item \code{"error"} throws an error if any needles have zero matches.
\item If a single integer is provided, this represents the count returned for
a needle with zero matches. The default value gives unmatched needles
a count of \code{0L}.
}}
}
\value{
An integer vector the same size as \code{needles}.
}
\description{
\code{iv_count_between()} counts instances of when \code{needles}, a vector, falls
between the bounds of \code{haystack}, an iv. It works similar to \code{\link[base:match]{base::match()}},
where \code{needles[i]} checks for a match in all of \code{haystack}.

This function returns an integer vector the same size as \code{needles}
containing a count of the times where the \code{i}-th value of \code{needles}
fell between any interval of \code{haystack}.
}
\examples{
x <- as.Date(c("2019-01-05", "2019-01-10", "2019-01-07", "2019-01-20"))

y <- iv_pairs(
  as.Date(c("2019-01-01", "2019-01-03")),
  as.Date(c("2019-01-04", "2019-01-08")),
  as.Date(c("2019-01-07", "2019-01-09")),
  as.Date(c("2019-01-10", "2019-01-20")),
  as.Date(c("2019-01-15", "2019-01-20"))
)

x
y

# Count the number of times `x` is between the intervals in `y`
iv_count_between(x, y)

# ---------------------------------------------------------------------------

a <- c(1, NA)
b <- iv(c(NA, NA), c(NA, NA))

# By default, missing values in `needles` are treated as being exactly
# equal to missing intervals in `haystack`, so the missing value in `a` is
# considered between the missing interval in `b`.
iv_count_between(a, b)

# If you'd like to propagate missing values, set `missing = NA`
iv_count_between(a, b, missing = NA)

# If you'd like missing values to be treated as unmatched, set
# `missing = 0L`
iv_count_between(a, b, missing = 0L)
}
\seealso{
\link[=iv_locate_between]{Locating where a vector falls between an iv}
}
