% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tSchurPolynomial.R
\name{tSkewSchurPol}
\alias{tSkewSchurPol}
\title{Skew t-Schur polynomial}
\usage{
tSkewSchurPol(n, lambda, mu)
}
\arguments{
\item{n}{number of variables, a positive integer}

\item{lambda, mu}{integer partitions defining the skew partition:
\code{lambda} is the outer partition and \code{mu} is the inner partition
(so \code{mu} must be a subpartition of \code{lambda})}
}
\value{
A \code{symbolicQspray} multivariate polynomial, the skew
  t-Schur polynomial associated to the skew partition defined by
  \code{lambda} and \code{mu}.
  It has a single parameter usually denoted by \eqn{t} and its
  coefficients are polynomials in this parameter. Substituting
  \eqn{t} with \eqn{0} yields the skew Schur polynomials.
}
\description{
Returns the skew t-Schur polynomial associated to
  the given skew partition.
}
