% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_genome.R
\name{create_genome}
\alias{create_genome}
\title{Create a reference genome.}
\usage{
create_genome(n_seqs, len_mean, len_sd = 0, pi_tcag = rep(0.25, 4),
  n_threads = 1)
}
\arguments{
\item{n_seqs}{Number of sequences.}

\item{len_mean}{Mean for the gamma distribution of sequence sizes.}

\item{len_sd}{Standard deviation for the gamma distribution of sequence sizes.
If set to \code{<= 0}, all sequences will be the same length. Defaults to \code{0}.}

\item{pi_tcag}{Vector of length 4 containing the nucleotide equilibrium frequencies
for "T", "C", "A", and "G", respectively. Defaults to \code{rep(0.25, 4)}.}

\item{n_threads}{Number of threads to use for parallel processing. This argument is
ignored if OpenMP is not enabled. Defaults to \code{1}.}
}
\value{
A \code{\link{ref_genome}} object.
}
\description{
Random sequences are generated to create a new \code{ref_genome} object.
Note that this function will never generate empty sequences.
}
\examples{

genome <- create_genome(10, 100e3, 100, pi_tcag = c(0.1, 0.2, 0.3, 0.4))

}
