% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wsigma.R
\name{wsigma}
\alias{wsigma}
\title{Weierstrass sigma function}
\usage{
wsigma(z, g = NULL, omega = NULL, tau = NULL)
}
\arguments{
\item{z}{a complex number, vector or matrix}

\item{g}{the elliptic invariants, a vector of two complex numbers; only 
one of \code{g}, \code{omega} and \code{tau} must be given}

\item{omega}{the half-periods, a vector of two complex numbers; only 
one of \code{g}, \code{omega} and \code{tau} must be given}

\item{tau}{the half-periods ratio; supplying \code{tau} is equivalent to 
supply \code{omega = c(1/2, tau/2)}}
}
\value{
A complex number, vector or matrix.
}
\description{
Evaluation of the Weierstrass sigma function.
}
\examples{
wsigma(1, g = c(12, -8))
# should be equal to:
sin(1i*sqrt(3))/(1i*sqrt(3)) / sqrt(exp(1))
}
