% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conformalMaps.R
\name{square2H}
\alias{square2H}
\title{Square to upper half-plane}
\usage{
square2H(z)
}
\arguments{
\item{z}{a complex number in the unit square \eqn{[0,1] \times [0,1]}}
}
\value{
A complex number in the upper half-plane.
}
\description{
Conformal map from the unit square to the upper half-plane. 
  The function is vectorized.
}
\examples{
n <- 1024L
x <- y <- seq(0.0001, 0.9999, length.out = n)
Grid <- transform(
  expand.grid(X = x, Y = y), 
  Z = complex(real = X, imaginary = Y)
)
\donttest{K <- kleinj(square2H(Grid$Z))
dim(K) <- c(n, n)
# plot
if(require("RcppColors")) {
  img <- colorMap5(K)
} else {
  img <- as.raster((Arg(K) + pi)/(2*pi))
}
opar <- par(mar = c(0, 0, 0, 0))
plot(NULL, xlim = c(0, 1), ylim = c(0, 1), asp = 1, 
     axes = FALSE, xaxs = "i", yaxs = "i", xlab = NA, ylab = NA)
rasterImage(img, 0, 0, 1, 1)
par(opar)}
}
