% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envelope.R
\name{overlayenvelope}
\alias{overlayenvelope}
\title{Overlay envelope plots}
\usage{
overlayenvelope(
  df,
  p = NULL,
  x = NA,
  row = NULL,
  column = NULL,
  median = TRUE,
  ci = c(0.5, 0.95),
  col = NULL,
  add = FALSE,
  dark = 0.3,
  outline = FALSE,
  xlab = "",
  ylab = "",
  main = NULL,
  ylim = NULL,
  legend = TRUE,
  legendnames = NULL,
  legendpos = "topleft",
  transform = c("none", "exp", "expit"),
  ...
)
}
\arguments{
\item{df}{Primary input can be specified in a number of ways: either a \code{list()} of posterior \code{data.frame}s or matrices,
a \code{list} of output objects returned from \code{jagsUI::jags()}, a 3-dimensional \code{array} in which the input matrices to plot
are separated according to the 3rd array dimension, or a single output object returned from \code{jagsUI::jags()} with multiple
arguments passed to \code{p}, following.}

\item{p}{Parameter name, if input to \code{df} is a list of \code{jagsUI} output objects; or a vector of parameter names, if
input to \code{df} is a single \code{jagsUI} output object.}

\item{x}{Optional vector of X-coordinates for plotting.}

\item{row}{Row to subset, in the case of a 2-d matrix of parameter nodes in-model.}

\item{column}{Column to subset, in the case of a 2-d matrix of parameter nodes in-model.}

\item{median}{Whether to include median line}

\item{ci}{Vector of intervals to overlay.  Defaults to 50 percent and 95 percent.}

\item{col}{Vector of colors for plotting}

\item{add}{Whether to add to existing plot}

\item{dark}{Opacity (0-1) for envelopes.  Note that multiple overlapping intervals will darken the envelope.  Defaults to 0.3.}

\item{outline}{Whether to just envelope outlines}

\item{xlab}{X-axis label}

\item{ylab}{Y-axis label}

\item{main}{Plot title.  If the default (\code{NULL}) is accepted and argument \verb{p=} is used, \code{p} will be used for the title.}

\item{ylim}{Y-axis limits for plotting.  If the default (\code{NULL}) is accepted, these will be determined automatically.}

\item{legend}{Whether to automatically try to add a legend.  Defaults to \code{TRUE}.}

\item{legendnames}{Optional vector of names for a legend.}

\item{legendpos}{Position for optional legend.  Defaults to \code{"topleft"}.}

\item{transform}{Should the y-axis be (back)transformed?  Options are \code{"exp"},
indicating exponential, or \code{"expit"}, indicating inverse-logit. Defaults to
\code{"none"}, indicating no transformation.  Note: if \code{transform="exp"}is used, consider
adding additional plotting argument \code{log="y"}.}

\item{...}{additional plotting arguments or arguments to \code{lines()}}
}
\value{
\code{NULL}
}
\description{
Overlays multiple envelope plots of posterior \code{data.frames}, or outputs returned from \code{jagsUI}.
This would be best suited to a set of posterior \code{data.frames} or 2-d matrices representing sequential vectors of parameter nodes.

Here a single \link{envelope} plot is defined as a set of overlayed shaded strips, each corresponding to a given
interval width (defaults to 50 percent and 95 percent), with an overlayed
median line.
}
\examples{
## usage with list of input data.frames
overlayenvelope(df=list(SS_out$sims.list$cycle_s[,,1],
                            SS_out$sims.list$cycle_s[,,2]))

## usage with a 3-d input array
overlayenvelope(df=SS_out$sims.list$cycle_s)

## usage with a jagsUI output object and parameter name (2-d parameter)
overlayenvelope(df=SS_out, p="cycle_s")

## usage with a single jagsUI output object and multiple parameters
overlayenvelope(df=SS_out, p=c("trend","rate"))

## exponential transformation
overlayenvelope(df=SS_out, p="cycle_s", transform="exp",
                ylab="exp transform")
overlayenvelope(df=SS_out, p="cycle_s", transform="exp",
                ylab="exp transform", log="y")
}
\seealso{
\link{envelope}, \link{crossplot}
}
\author{
Matt Tyers
}
