% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-package.R
\docType{package}
\name{jamba-package}
\alias{jamba}
\alias{jamba-package}
\title{jamba: Jam Base Methods}
\description{
The jamba package contains several jam base functions
which are re-usable for routine R analysis work, and are
important dependencies for other Jam R packages.
}
\details{
See the function reference for a complete list of functions.

The goal is to implement methods as lightweight as possible, so
so inclusion in an analysis workflow will not incur
a noticeable burden.
}
\section{plot functions}{

\itemize{
\item \code{\link[=plotSmoothScatter]{plotSmoothScatter()}} smoothScatter() enhanced for more visual detail
\item \code{\link[=imageDefault]{imageDefault()}} enhanced rasterized image() with fixed aspect ratio
\item \code{\link[=imageByColors]{imageByColors()}} for \code{data.frame} of colors and optional
labels centered across repeated values.
\item \code{\link[=showColors]{showColors()}} color display for vector, list, color function,
or mixed formats.
\item \code{\link[=nullPlot]{nullPlot()}} blank plot that labels the current margin sizes
\item \code{\link[=minorLogTicksAxis]{minorLogTicksAxis()}} log-scale axis ticks in base R with
custom log base, optional offset, e.g. \code{log2(1 + x)}
\item \code{\link[=shadowText]{shadowText()}} base R text labels with shadow or outline or both,
also \code{\link[=shadowText_options]{shadowText_options()}}.
\item \code{\link[=getPlotAspect]{getPlotAspect()}}, \code{\link[=decideMfrow]{decideMfrow()}} convenience base R graphics.
}
}

\section{string functions}{

\itemize{
\item \code{\link[=mixedSort]{mixedSort()}}, \code{\link[=mixedOrder]{mixedOrder()}}, \code{\link[=mixedSortDF]{mixedSortDF()}} - efficient
alphanumeric "version" sort, with options helpful for gene symbols.
\item \code{\link[=vgrep]{vgrep()}}, \code{\link[=vigrep]{vigrep()}}, \code{\link[=igrep]{igrep()}}, \code{\link[=vigrep]{vigrep()}} fast grep wrappers
for value-return, case-insensitive search.
\item \code{\link[=provigrep]{provigrep()}}, \code{\link[=proigrep]{proigrep()}} - progressive, ordered grep to use
pattern matching to re-order a vector.
\item \code{\link[=makeNames]{makeNames()}} create unique, versioned names with custom format
\item \code{\link[=nameVector]{nameVector()}} apply names to vector dynamically
\item \code{\link[=nameVectorN]{nameVectorN()}} vector of named names useful with \code{\link[=lapply]{lapply()}}.
\item \code{\link[=pasteByRow]{pasteByRow()}}, \code{\link[=pasteByRowOrdered]{pasteByRowOrdered()}} paste data.frame and matrix
values by row, skipping blanks, optional factor order.
\item \code{\link[=rbindList]{rbindList()}} convert list to \code{matrix} or \code{data.frame}.
\item \code{\link[=tcount]{tcount()}} extends \code{table()} to sort by size and optional minimum
count filter.
}
}

\section{color functions}{

\itemize{
\item \code{\link[=rgb2col]{rgb2col()}}, \code{\link[=col2hcl]{col2hcl()}}, \code{\link[=col2hcl]{col2hcl()}}, \code{\link[=col2hsv]{col2hsv()}}, \code{\link[=hsv2col]{hsv2col()}} color
interconversion
\item \code{\link[=setTextContrastColor]{setTextContrastColor()}} text contrast color per given background color
\item \code{\link[=getColorRamp]{getColorRamp()}} catch-all to get named gradients, or expand
one or more colors to gradient.
\item \code{\link[=makeColorDarker]{makeColorDarker()}}, \code{\link[=color2gradient]{color2gradient()}}, \code{\link[=showColors]{showColors()}} color
manipulation and display
}
}

\section{miscellaneous helper functions}{

\itemize{
\item \code{\link[=printDebug]{printDebug()}} colored text output to console, 'Rmarkdown', HTML
\item \code{\link[=kable_coloring]{kable_coloring()}} colored \code{kableExtra::kable()} output for 'Rmarkdown'
\item \code{\link[=setPrompt]{setPrompt()}} colored R prompt
\item \code{\link[=deg2rad]{deg2rad()}}, \code{\link[=rad2deg]{rad2deg()}} interconvert degrees to radians.
\item \code{\link[=getDate]{getDate()}}, \code{\link[=asDate]{asDate()}}, \code{\link[=dateToDaysOld]{dateToDaysOld()}} human-readable,
opinionated date formatting
\item \code{\link[=padString]{padString()}}, \code{\link[=padInteger]{padInteger()}} pad character or integer strings
\item \code{\link[=rmNA]{rmNA()}}, \code{\link[=rmNULL]{rmNULL()}}, \code{\link[=rmInfinite]{rmInfinite()}} remove or replace missing or NA
values with defined alternatives
}
}

\section{export and import functions}{

\itemize{
\item \code{\link[=readOpenxlsx]{readOpenxlsx()}} import worksheets from 'xlsx' 'Excel' files.
\item \code{\link[=writeOpenxlsx]{writeOpenxlsx()}} export worksheets to 'xlsx' 'Excel' files with color,
formatting, and styling.
}
}

\section{Jam options}{

The \code{jamba} package recognizes some global options, but limits these
options to include only non-analysis options. For example, no global
option should change the numerical manipulation of data.
\itemize{
\item \code{jam.lightMode} - \code{logical} whether the R console or graphical
background is light or dark, \code{printDebug()} limits
the luminance range to maximize visual contrast.
\item \code{jam.Crange},\code{jam.Lrange} - numerical values used by \code{printDebug()}
to maximize visual contrast, used with \code{jam.lightMode}.
\item \code{jam.shadowColor},\code{jam.shadow.r},\code{jam.shadow.n},\code{jam.alphaShadow},
\code{jam.outline},\code{jam.alphaOutline} to customize details for \code{shadowText()},
see \code{shadowText_options()} for convenience.
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://jmw86069.github.io/jamba/}
  \item Report bugs at \url{https://github.com/jmw86069/jamba/issues}
}

}
\author{
\strong{Maintainer}: James M. Ward \email{jmw86069@gmail.com} (\href{https://orcid.org/0000-0002-9510-2848}{ORCID}) [copyright holder]

}
\keyword{internal}
